﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程老师关联仓储接口
    /// </summary>
    public interface ICourseTeacherRepository : IDBRepository<RB_Course_Teacher>, IDependency
    {
        /// <summary>
        /// 批量新增课程老师
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseTeacherRepository(List<RB_Course_Teacher> courses);


        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseListRepository(CourseQuery query);
    }
}
