﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 学员评价仓储接口
    /// </summary>
    public interface IStuCommentRepository:IDBRepository<RB_Stu_Comment>, IDependency
    {
        /// <summary>
        /// 新增修改学员评语
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuCommentRepository(RB_Stu_Comment_Extend model, bool IsAdd = false);

        /// <summary>
        /// 批量新增学员评价
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetStuCommentRepository(RB_Stu_Comment_Extend model, StuCommentType commentType );

        /// <summary>
        /// 获取系统生成评论次数 
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment_Extend> GetCourseCommentTimesListRepository(CourseQuery query);
    }
}
