﻿using System;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 作业实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_HomeWork
    {
		/// <summary>
		/// 作业编号
		/// </summary>
		public int Homework_id { get; set; }

		/// <summary>
		/// 作业标题
		/// </summary>
		public string Homework_title { get; set; }

		/// <summary>
		/// 作业分享Key
		/// </summary>
		public string Homework_share_key { get; set; }

		/// <summary>
		/// 课程编号
		/// </summary>
		public int Course_id { get; set; }

		/// <summary>
		/// 课程名称
		/// </summary>
		public string Course_name { get; set; }

		/// <summary>
		/// 作业开始时间
		/// </summary>
		public DateTime Start_time { get; set; }

		/// <summary>
		/// 作业结束时间
		/// </summary>
		public DateTime End_time { get; set; }

		/// <summary>
		/// 作业状态(0-未开始，1-进行中，2-已结束)
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 显示状态(0-客户端显示，1-客户端隐藏)
		/// </summary>
		public int Is_del { get; set; }

		/// <summary>
		/// 是否公开作业(1-公开作业，2-不公开，3-公开优秀)
		/// </summary>
		public int Is_open { get; set; }

		/// <summary>
		/// 公开方式(1-结束后)
		/// </summary>
		public int Open_type { get; set; }

		/// <summary>
		/// 是否允许补交(1-否,2-是)
		/// </summary>
		public int Is_revise { get; set; }

		/// <summary>
		/// 学生数
		/// </summary>
		public int Num { get; set; }

		/// <summary>
		/// 优秀人数
		/// </summary>
		public int Cream_num { get; set; }

		/// <summary>
		/// 补交人数
		/// </summary>
		public int Revised_num { get; set; }

		/// <summary>
		/// 已批阅
		/// </summary>
		public int Rnum { get; set; }

		/// <summary>
		/// 已提交
		/// </summary>
		public int Cnum { get; set; }

		/// <summary>
		/// 学校编号
		/// </summary>
		public int School_uid { get; set; }

		/// <summary>
		/// 评分机制(5-自定义，4-不评分，3-等第制，2-十分制，1-百分制)
		/// </summary>
		public int Score_type { get; set; }

		/// <summary>
		/// 自定义分数
		/// </summary>
		public decimal Score_value { get; set; }

		/// <summary>
		/// 教师账号
		/// </summary>
		public string Teacher_account { get; set; }

		/// <summary>
		/// 教师姓名
		/// </summary>
		public string Teacher_name { get; set; }

		/// <summary>
		/// 教师编号
		/// </summary>
		public int Teacher_uid { get; set; }

		/// <summary>
		/// th_cancel
		/// </summary>
		public string Th_cancel { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime Add_time { get; set; }

		/// <summary>
		/// 更新时间
		/// </summary>
		public DateTime Update_time { get; set; }

		/// <summary>
		/// 打回订正人数
		/// </summary>
		public int Ref_num { get; set; }

		/// <summary>
		/// 已订正人数
		/// </summary>
		public int Refc_num { get; set; }

		/// <summary>
		/// 平均分
		/// </summary>
		public decimal Av_score { get; set; }

		/// <summary>
		/// 最高分
		/// </summary>
		public decimal Max_score { get; set; }

		/// <summary>
		/// 最低分
		/// </summary>
		public decimal Min_score { get; set; }
	}
}
