﻿
using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.Services
{
    /// <summary>
    /// 课程服务实现
    /// </summary>
    public class CourseService : ICourseService
    {
        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseRepository  CourseRepository { get; set; }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCourseList(CourseQuery query)
        {
            return CourseRepository.GetCourseListRepository(query);
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCoursePage(int pageIndex, int pageSize, out long rowsCount, CourseQuery query)
        {
            return CourseRepository.GetCoursePageRepository(pageIndex, pageSize, out rowsCount, query);
        }
    }
}
