﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;
using EduSpider.Utility;
using System.Threading;
using EduSpider.Model.Extend;
using System.Linq;
using JWT;
using System;
using System.Collections.Generic;
using JWT.Algorithms;
using JWT.Serializers;
using System.IO;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 上传文件
    /// </summary>
    [EnableCors("AllowCors")]
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class UploadController : ControllerBase
    {
        /// <summary>
        /// 考试
        /// </summary>
        [Autowired]
        public IExamService ExamService { get; set; }


        /// <summary>
        /// 导入考试成绩
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult UploadStuExamScore()
        {
            try
            {
                var files = Request.Form.Files;
                if (files.Count == 0)
                {
                    return new ApiResult { Code = (int)ResultCode.Fail, Message = "未选择文件", Data = "" };
                }
                var json = !string.IsNullOrEmpty(Request.Form["params"]) ? JObject.Parse(Request.Form["params"].ToString()) : null;
                int UserId = Convert.ToInt32(json["Uid"] != null ? json["Uid"].ToString() : "0");
                int CourseId = Convert.ToInt32(json["CourseId"] != null ? json["CourseId"].ToString() : "0");
                string ExamName = json["ExamName"] != null ? json["ExamName"].ToString() : "";

                string filename = files[0].FileName;
                string fileExtention = Path.GetExtension(files[0].FileName);
                //验证文件格式
                List<string> ExtList = new() {
                    ".xls",
                    ".xlsx"
                };
                if (!ExtList.Contains(fileExtention))
                {
                    return new ApiResult { Code = (int)ResultCode.Fail, Message = "文件格式有误", Data = "" };
                }
                if (files[0].Length <= 0)
                {
                    return new ApiResult { Code = (int)ResultCode.Fail, Message = "文件大小有误", Data = "" };
                }
                decimal fileMNum = files[0].Length / (1024 * 1024);
                if (fileMNum > 10) { return ApiResult.Failed("文件不能超过10M"); }

                string path = Guid.NewGuid().ToString() + fileExtention;
                string basepath = AppContext.BaseDirectory;
                string dateStr = DateTime.Now.ToString("yyyyMMdd");
                string tempPath = basepath + "upfile\\temporary\\" + dateStr + "\\";
                string path_server = tempPath + path;
                if (!Directory.Exists(tempPath))
                {
                    Directory.CreateDirectory(tempPath);
                }
                using (FileStream fstream = new(path_server, FileMode.OpenOrCreate, FileAccess.ReadWrite))
                {
                    files[0].CopyTo(fstream);
                }

                #region 解析文档数据并保存
                string rmsg = ExamService.ImportExcelForStuExamScore(path_server, CourseId, ExamName, UserId);
                if (rmsg == "")
                {
                    try
                    {
                        System.IO.File.Delete(path_server);//删除原文件
                    }
                    catch (Exception)
                    {
                        LogHelper.WriteError("UploadStuExamScore", "删除原文件失败");
                    }
                    return ApiResult.Success();
                }
                else
                {
                    return ApiResult.Failed(rmsg);
                }
                #endregion
            }
            catch (Exception ex)
            {
                LogHelper.WriteError("UploadStuExamScore", "", ex);
                return ApiResult.Failed();
            }
        }


        /// <summary>
        /// 导入考试成绩
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public ApiResult UploadStuExamScore_Test()
        {
            try
            {
                string path_server = "C:/Users/Administrator/Desktop/TempFile/进阶小程序考试导入/初中鸿志班第三次测试3组.xlsx";

                #region 解析文档数据并保存
                string rmsg = ExamService.ImportExcelForStuExamScore(path_server, 208720463, "测试考试化学2", 646277);
                if (rmsg == "")
                {
                    return ApiResult.Success();
                }
                else
                {
                    return ApiResult.Failed(rmsg);
                }
                #endregion
            }
            catch (Exception ex)
            {
                LogHelper.WriteError("UploadStuExamScore", "", ex);
                return ApiResult.Failed();
            }
        }
    }
}
