﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Text.RegularExpressions;
using System.Linq;

namespace EduSpider.Utility.Data
{
    /// <summary>
    /// 学生成绩导入帮助类
    /// </summary>
    public class StuExamScoreHelper
    {
        /// <summary>
        /// 根据Excel文件获取列表
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static List<ExamQuestionModel> GetStuExamScoreData(string filePath, out List<StuScoreModel> StuList, out string msg, out int type)
        {
            msg = ""; type = 1;
            StuList = new List<StuScoreModel>();
            var dt = NPOIHelper.ImportExcelToDatatable(filePath, 0, 0, true);
            List<ExamQuestionModel> EQList = new List<ExamQuestionModel>();
            if (dt != null && dt.Rows.Count > 0)
            {
                if (dt.Columns.Contains("分组"))
                {
                    type = 2;
                    //首先抓取 分组列
                    List<string> colList = new List<string>();
                    foreach (var item in dt.Columns)
                    {
                        if (item == null) {
                            msg = "分组项有误，请核实后再试";
                            return new List<ExamQuestionModel>();
                        }
                        colList.Add(item.ToString());
                        if (item != null && item.ToString() == "百分比排名") { break; }//最后一个了 跳出循环
                    }

                    //抓取题号  
                    #region 验证题号是否连续
                    List<int> THList = new List<int>();
                    string GroupName = "";//分组名称
                    foreach (var item in colList)
                    {
                        if (item == "分组" || item == "总分" || item == "排名" || item == "百分比排名") { continue; }
                        string TH = dt.Rows[0][item].ToString();
                        if (string.IsNullOrEmpty(TH)) {
                            msg = "题号有合并行/题号不存在，请处理后再试";
                            return new List<ExamQuestionModel>();
                        }
                        if (!item.Contains("Column")) {
                            GroupName = item;
                        }
                        if (string.IsNullOrEmpty(GroupName)) {
                            msg = "分组项有误，请核实后再试";
                            return new List<ExamQuestionModel>();
                        }
                        EQList.Add(new ExamQuestionModel()
                        {
                            Id = TH == "" ? 0 : Convert.ToInt32(TH),
                            Difficulty = dt.Rows[1][item].ToString(),
                            KnowledgePoint = dt.Rows[2][item].ToString(),
                            Score = Convert.ToDecimal(dt.Rows[3][item].ToString()),
                            GroupName = GroupName,
                            ColName = item
                        });
                        THList.Add(TH == "" ? 0 : Convert.ToInt32(TH));
                        if (item != null && item.ToString() == "百分比排名") { break; }//最后一个了 跳出循环
                    }
                    if (THList.Any())
                    {
                        int Num = 1;//必须从第一题开始
                        foreach (var item in THList)
                        {
                            if (item != Num)
                            {
                                msg = $"第{Num}题不存在/题号有误，请核实后再试";
                                return new List<ExamQuestionModel>();
                            }
                            Num++;
                        }
                    }
                    else
                    {
                        msg = "题号不存在，请核实后再试";
                        return new List<ExamQuestionModel>();
                    }
                    #endregion
                    if (EQList.Any())
                    {
                        int totalCount = dt.Rows.Count;
                        //从第5行 开始  是学生
                        for (var i = 4; i < totalCount; i++)
                        {
                            string StuName = dt.Rows[i]["分组"].ToString().Trim();
                            foreach (var item in EQList)
                            {
                                string v = dt.Rows[i][item.ColName].ToString();
                                if (string.IsNullOrEmpty(v))
                                {
                                    msg = $"第{i + 1}行，第{item.Id}题得分为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                //先装姓名
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = item.Id,
                                    Score = Convert.ToDecimal(v == "" ? "0" : v)
                                });
                            }
                            if (i < totalCount - 1)
                            {
                                string z = dt.Rows[i]["总分"].ToString();
                                if (string.IsNullOrEmpty(z))
                                {
                                    msg = $"第{i + 1}行，总分为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                //总分  排名  百分比排名
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -1,
                                    Score = Convert.ToDecimal(z == "" ? "0" : z)
                                });
                                string p = dt.Rows[i]["排名"].ToString();
                                if (string.IsNullOrEmpty(p) && StuName != "平均分")
                                {
                                    msg = $"第{i + 1}行，排名为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -2,
                                    Score = Convert.ToDecimal(p == "" ? "0" : p)
                                });
                                string b = dt.Rows[i]["百分比排名"].ToString();
                                if (string.IsNullOrEmpty(b) && StuName != "平均分")
                                {
                                    msg = $"第{i + 1}行，百分比排名排名为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -3,
                                    Score = Convert.ToDecimal(b == "" ? "0" : b)
                                });
                            }

                            if (StuName == "平均分")
                            {
                                break;
                            }
                        }
                    }
                }
                else
                {
                    #region 验证题号是否连续
                    List<int> THList = new List<int>();
                    foreach (var item in dt.Columns)
                    {
                        if (item != null && item.ToString().Contains("Column"))
                        {
                            msg = "题号有合并行，请处理成单行后再试";
                            return new List<ExamQuestionModel>();
                        }
                        if (item != null && ValidateInt(item.ToString()))
                        {
                            THList.Add(Convert.ToInt32(item.ToString()));
                        }
                        if (item != null && item.ToString() == "百分比排名") { break; }//最后一个了 跳出循环
                    }
                    if (THList.Any())
                    {
                        int Num = 1;//必须从第一题开始
                        foreach (var item in THList) {
                            if (item != Num) {
                                msg = $"第{Num}题不存在/题号有误，请核实后再试";
                                return new List<ExamQuestionModel>();
                            }
                            Num++;
                        }
                    }
                    else {
                        msg = "题号不存在，请核实后再试";
                        return new List<ExamQuestionModel>();
                    }
                    #endregion

                    //先抓取 题目列表
                    for (var i = 1; i < 1000; i++)
                    {
                        if (dt.Columns.Contains(i.ToString()))
                        {
                            EQList.Add(new ExamQuestionModel()
                            {
                                Id = i,
                                Difficulty = dt.Rows[0][i.ToString()].ToString(),
                                KnowledgePoint = dt.Rows[1][i.ToString()].ToString(),
                                Score = Convert.ToDecimal(dt.Rows[2][i.ToString()].ToString())
                            });
                        }
                        else
                        {
                            break;
                        }
                    }
                    if (EQList.Any())
                    {
                        int totalCount = dt.Rows.Count;
                        //从第5行 开始  是学生
                        for (var i = 3; i < totalCount; i++)
                        {
                            string StuName = dt.Rows[i]["题号"].ToString().Trim();
                            foreach (var item in EQList)
                            {
                                string v = dt.Rows[i][item.Id.ToString()].ToString();
                                if (string.IsNullOrEmpty(v))
                                {
                                    msg = $"第{i}行，第{item.Id}题得分为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                //先装姓名
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = item.Id,
                                    Score = Convert.ToDecimal(v == "" ? "0" : v)
                                });
                            }
                            if (i < totalCount - 1)
                            {
                                string z = dt.Rows[i]["总分"].ToString();
                                if (string.IsNullOrEmpty(z))
                                {
                                    msg = $"第{i}行，总分为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                //总分  排名  百分比排名
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -1,
                                    Score = Convert.ToDecimal(z == "" ? "0" : z)
                                });
                                string p = dt.Rows[i]["排名"].ToString();
                                if (string.IsNullOrEmpty(p) && StuName != "平均分")
                                {
                                    msg = $"第{i}行，排名为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -2,
                                    Score = Convert.ToDecimal(p == "" ? "0" : p)
                                });
                                string b = dt.Rows[i]["百分比排名"].ToString();
                                if (string.IsNullOrEmpty(b) && StuName != "平均分")
                                {
                                    msg = $"第{i}行，百分比排名排名为空，请核实后再试";
                                    return new List<ExamQuestionModel>();
                                }
                                StuList.Add(new StuScoreModel()
                                {
                                    Name = StuName,
                                    Id = -3,
                                    Score = Convert.ToDecimal(b == "" ? "0" : b)
                                });
                            }

                            if (StuName == "平均分")
                            {
                                break;
                            }
                        }
                    }
                }
            }
            return EQList;
        }

        /// <summary>
        /// 验证是否为数字
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool ValidateInt(string value)
        {
            return Regex.IsMatch(value, @"^[0-9]*$");
        }
    }

    /// <summary>
    /// 考题
    /// </summary>
    public class ExamQuestionModel {
        /// <summary>
        /// 题目编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 难度
        /// </summary>
        public string Difficulty { get; set; }

        /// <summary>
        /// 知识点
        /// </summary>
        public string KnowledgePoint{ get; set; }

        /// <summary>
        /// 分数
        /// </summary>
        public decimal Score { get; set; }

        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 列名
        /// </summary>
        public string ColName { get; set; }
    }

    /// <summary>
    /// 学生成绩
    /// </summary>
    public class StuScoreModel { 

        /// <summary>
        /// 学生姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 考题编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 得分
        /// </summary>
        public decimal Score { get; set; }
    }
}
