﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Helper;

namespace EduSpider.Spiders.SchoolHouseKeeper
{
    /// <summary>
    /// 校管家课程关联
    /// </summary>
    public class SchoolCourseManager
    {

        public class PageModel
        {
            public int PageIndex { get; set; }
            public int PageSize { get; set; }
        }


        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static async void RunCourse(string cookie)
        {
            var pageModel = new PageModel
            {
                PageIndex = 1,
                PageSize = 10
            };
            int totalCount = 0, pageCount = 0;
            string url = "https://tms11.xiaogj.com/api/Shift/Query";
            string result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie);
            List<SchoolCourseItem> list = new List<SchoolCourseItem>();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                totalCount = jobj.GetInt("TotalCount");
                pageCount = jobj.GetInt("PageCount");
                list = ParseJson(jobj.GetString("Data"));
                if (pageCount > pageModel.PageIndex)
                {
                    for (var i = 2; i <= pageCount; i++)
                    { 
                    
                    }
                }
            }
            Console.WriteLine("result:" + result);

        }

        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<SchoolCourseItem> ParseJson(string data)
        {
            List<SchoolCourseItem> list = new List<SchoolCourseItem>();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());

                        var model = new SchoolCourseItem()
                        {
                            ID = cObj.GetString("ID"),
                            Name = cObj.GetString("Name"),
                            IsOneToOne = cObj.GetInt("IsOneToOne"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }
    }

    /// <summary>
    /// 校管家课程实体
    /// </summary>
    public class SchoolCourseItem
    {
        /// <summary>
        /// 课程编号GUID
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 是否一对一
        /// </summary>
        public int IsOneToOne { get; set; }
    }
}
