﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility.Enum;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 课程关联
    /// </summary>
    public class TeacherManager
    {

        /// <summary>
        /// 获取老师列表
        /// </summary>
        public async void RunTeacher(string cookie)
        {
            int perpage = 20, pageIndex = 1, pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            List<RB_Teacher> list = new();
            while (true) {
                string paramStr = string.Format("page={0}&perpage={1}", pageIndex, perpage);
                var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                var response = await request.PostAsync("https://console.eeo.cn/saasajax/teacher.ajax.php?action=getSchoolTeacherFullList", content);

                var result = response.Content.ReadAsStringAsync().Result;

                if (!string.IsNullOrWhiteSpace(result))
                {
                    JObject rootObj = JObject.Parse(result);
                    if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                    {
                        JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                        var totalNum = dataObj.GetInt("totalNum");
                        string rlist = dataObj.GetString("list");
                        if (pageIndex == 1)
                        {
                            if (totalNum > perpage)
                            {
                                if (totalNum % perpage == 0)
                                {
                                    pageCount = totalNum / perpage;
                                }
                                else
                                {
                                    pageCount = (totalNum / perpage) + 1;
                                }
                            }
                        }

                        list.AddRange(ParseJson(rlist));
                    }
                }
                else
                {
                    Console.WriteLine("result", result);
                }
                if (pageIndex == pageCount) {
                    break;
                }
                pageIndex++;
            }
            
            ITeacherRepository teacherRepository = new TeacherRepository();
            teacherRepository.BatchSetTeache(list.OrderBy(x => x.TeacherId).ToList());
        }

        /// <summary>
        /// 数据转换
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<RB_Teacher> ParseJson(string data)
        {
            List<RB_Teacher> list = new();
           JArray courseArray = JArray.Parse(data);
            if (courseArray != null && courseArray.Count > 0)
            {
                foreach (var jItem in courseArray)
                {
                    JObject rObj = JObject.Parse(jItem.ToString());
                    string Logo = rObj.GetString("logo");
                    if (!string.IsNullOrEmpty(Logo)) {
                        Logo = "https://console.eeo.cn/upload/images/" + Logo;
                    }
                    list.Add(new RB_Teacher()
                    {
                        TeacherId = rObj.GetInt("id"),
                        TeacherUid = rObj.GetInt("uid"),
                        Introduce = rObj.GetString("introduce"),
                        IsGroup = rObj.GetInt("isGroup"),
                        Logo = Logo,
                        Sex = rObj.GetInt("sex"),
                        Status = rObj.GetInt("status"),
                        TeacherAccount = rObj.GetString("account"),
                        TeacherName = rObj.GetString("name"),
                        TeacherNo = rObj.GetString("empno"),
                        Position = rObj.GetString("position"),
                        RegionId = rObj.GetInt("regionId"),
                        PublicResourceStatus = rObj.GetInt("publicResourceStatus"),
                        ClientCreateCourse = rObj.GetString("clientCreateCourse"),
                        TeacherLabels = rObj.GetString("teacherLabels"),
                        Progress = rObj.GetString("progress")
                    });
                }
            }

            return list;
        }
    }
}
