﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程学员关联仓储层
    /// </summary>
    public class CourseStudentRepository : BaseRepository<RB_Course_Student>, ICourseStudentRepository
    {
        /// <summary>
        /// 批量新增课程学员
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseStudentRepository(List<RB_Course_Student> courses)
        {
            bool flag;
            flag = base.BatchInsert(courses, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 跟进查询条件获取课程学员列表
        /// </summary>
        /// <param name="courseQuery"></param>
        /// <returns></returns>
        public List<RB_Course_Student> GetCourseStudentListRepository(CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Course_Student AS A
WHERE 1=1
");
            if (query != null)
            {
           
                if (query.courseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course_Student.courseId), query.courseId);
                }
            }
            return base.Get<RB_Course_Student>(builder.ToString(), parameters).ToList();
        }
    }
}
