﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using VTX.FW.Api;
using VTX.FW.Attr;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 课程控制器
    /// </summary>

    public class CourseController : BaseController
    {
        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]

        public ApiResult GetCoursePage()
        {
            var list = CourseService.GetCoursePage(1, 1000, out _, new Model.Query.CourseQuery());
            return ApiResult.Success(data: list, message: "成功!");
        }
    }
}
