﻿using System;
using System.Net;
using System.Net.Http;


namespace EduSpider.Utility
{
    /// <summary>
    /// Http请求帮助类
    /// </summary>
    public class HttpHelper
    {
        public static HttpClient GenerateHttp(string cookie)
        {
            var handler = new HttpClientHandler();
            handler.AllowAutoRedirect = false;
            handler.UseCookies = true;
            handler.CookieContainer = CreateCookie(cookie);
            handler.AutomaticDecompression = DecompressionMethods.GZip;
            handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
            var http = new HttpClient(handler);
            GenerateHttpHeader(ref http);

            return http;
        }

        private static void GenerateHttpHeader(ref HttpClient http)
        {
            http.DefaultRequestHeaders.Add("Accept", "application/json, text/plain, */*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9,ja;q=0.8");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            http.DefaultRequestHeaders.Add("Origin", "https://console.eeo.cn");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://console.eeo.cn/saas/school/index.html");
            http.DefaultRequestHeaders.Add("salesChannel", "NzcwMQ==");
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");


            http.DefaultRequestHeaders.Add("site", "zh_CN");
            http.DefaultRequestHeaders.Add("shakehand", "535206fb27efbaf75066ff179b975ff6");
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }

        /// <summary>
        /// 拼接Cookie
        /// </summary>
        /// <param name="cookieStr"></param>
        /// <returns></returns>
        private static CookieContainer CreateCookie(string cookieStr)
        {
            var uri = new Uri("https://console.eeo.cn");
            var cc = new CookieContainer();

            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }
    }
}