﻿using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TicketSpider.Spiders.EasterLineRule
{
    public class CookiesHelper
    {
        /// <summary>
        /// 获取初始化Cookies
        /// </summary>
        /// <returns></returns>
        public Task<string> GetInitCookie()
        {
            var cookieStr = string.Empty;
            var option = new ChromeOptions();
            option.AddArgument("--incognito");
            option.AddArgument("headless");
            option.AddArgument("disable-infobars");
            option.AddArgument("window-size=1920,1080");
            option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36");
            ChromeDriverService service = ChromeDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            IWebDriver driver = new ChromeDriver(service, option);
            try
            {
                
                var param = "{\"travelType\":\"oneway\",\"passengerNum\":\"1,0,0\",\"depCity\":\"BKK\",\"arrCity\":\"SHA\",\"depValues\":\"BKK\",\"arrValues\":\"PVG, SHA\",\"depCityName\":\"曼谷\",\"arrCityName\":\"上海\",\"date\":\"2022-12-11\",\"cabinClass\":\"ALL\",\"payWay\":\"money\",\"depSelectValue\":\"BKK\",\"arrSelectValue\":\"PVG, SHA\",\"depLabel\":\"\",\"arrLabel\":\"\",\"isArrCity\":true,\"isDepCity\":true,\"arrCn\":\"CN\",\"depCn\":\"TH\",\"t\":" + DateTime.Now.Ticks + "}";
                param = System.Web.HttpUtility.UrlEncode(param);
                param = Convert.ToBase64String(Encoding.UTF8.GetBytes(param));
                driver.Navigate().GoToUrl($"https://www.ceair.com/shopping?searchKey={param}ENCODEKEY");

                foreach (var item in driver.Manage().Cookies.AllCookies)
                {
                    cookieStr += item.Name + "=" + item.Value + ";";
                }
                cookieStr = cookieStr.Substring(0, cookieStr.Length - 1);
            }
            catch (Exception ex)
            {
                Console.WriteLine($"获取cooki失败，{ex.Message}");
            }
            driver.Quit();
            return Task.FromResult(cookieStr);
        }
    }
}
