﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;
using VTX.FW.DB;
using VTX.FW.DB.Enumeration;

namespace EduSpider.Repository.Base
{
    /// <summary>
    /// 仓储基类
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class BaseRepository<T> : DBRepository<T> where T : class, new()
    {
        /// <summary>
        /// 数据库连接字符串
        /// </summary>
        private readonly string DBConnStr = "";

        private readonly DataBaseTypeEnum dbType = DataBaseTypeEnum.MySql;

        public BaseRepository()
        {
            string connKey = "";
            try
            {
                var classAttribute = (DBAttribute)Attribute.GetCustomAttribute(typeof(T), typeof(DBAttribute));
                connKey = classAttribute?.ConnectionName ?? "DefaultConnection";
            }
            catch
            {

            }
            DBConnStr = VTX.FW.Helper.ConfigHelper.GetConnectionString(connKey);
        }


        public override string ConnectionStr { get => DBConnStr; set => base.ConnectionStr = DBConnStr; }

        public override DataBaseTypeEnum DBType { get => dbType; set => base.DBType = dbType; }
    }
}
