﻿using Newtonsoft.Json.Linq;
using System;
using System.IO;
using System.Net;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Utility
{
    /// <summary>
    /// Http请求帮助类
    /// </summary>
    public class HttpHelper
    {
        /// <summary>
        /// 域名
        /// </summary>
        private static string domain = "https://console.eeo.cn/saasajax";

        /// <summary>
        /// Cookie
        /// </summary>
        private static string Cookie = "sajssdk_2015_cross_new_user=1; _eeos_uid=12780052; _eeos_useraccount=18140082327; _eeos_userlogo=%2Fupload%2Fimages%2F20200126%2F709df9532bee722f2268_70.jpg; _eeos_domain=.eeo.cn; _eeos_remember=1; _eeos_traffic=EqlIOFq4S2hz5FTTtHzNUViBYcWCixrJYMCF6Y5yJuD8eq8ZwPvVSHMvUkLFA5lzNoaTrDBpGhG4CE5Tjuw%2BomVQCAXfwH%2BefAyKrRMPc3g%3D; _eeos_sid=12780052; _eeos_nsid=kspGu2gfMu%2BU2EFgLpSGyg%3D%3D; locationArgumentLang=zh-CN; sensorsdata2015jssdkcross=%7B%22distinct_id%22%3A%2212780052%22%2C%22first_id%22%3A%22180f54ced3048f-02eaffc35f728a-3e604809-2073600-180f54ced316ee%22%2C%22props%22%3A%7B%22%24latest_traffic_source_type%22%3A%22%E8%87%AA%E7%84%B6%E6%90%9C%E7%B4%A2%E6%B5%81%E9%87%8F%22%2C%22%24latest_search_keyword%22%3A%22%E6%9C%AA%E5%8F%96%E5%88%B0%E5%80%BC%22%2C%22%24latest_referrer%22%3A%22https%3A%2F%2Fwww.baidu.com%2Flink%22%7D%2C%22%24device_id%22%3A%22180f54ced3048f-02eaffc35f728a-3e604809-2073600-180f54ced316ee%22%7D; PHPSESSID=sd33g5i5ta97b7a8d19vld71q2; __tk_id=0a89552a4b2a69f62bc9ad086c6402e1";

        /// <summary>
        /// 类型
        /// </summary>
        private static string contentType = "application/x-www-form-urlencoded";

        /// <summary>
        /// 获取班级信息
        /// </summary>
        /// <returns></returns>
        public static string GetClassQuery()
        {
            string url = "/course.ajax.php?action=getCourseList";
            string ApiUrl = domain + url;
            string apiResult = HttpPost(ApiUrl, "", contentType:contentType, cookie: Cookie);
            if (!string.IsNullOrWhiteSpace(apiResult))
            {
                JObject rootObj = JObject.Parse(apiResult);
                int PageSize = rootObj.GetInt("PageSize");
                int PageCount= rootObj.GetInt("PageCount");
            }
            
            return apiResult;
        }

        public static string GetData(string url)
        {
            return "";
        }


        /// <summary>
        /// Post提交数据
        /// </summary>
        /// <param name="url">url地址</param>
        /// <param name="body">参数</param>
        /// <param name="contentType">参数</param>
        /// <returns></returns>
        public static string HttpPost(string url, string body, string contentType = "", string cookie = "")
        {
            string result = "";
            try
            {
                Encoding encoding = Encoding.UTF8;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.Method = "POST";

                request.Accept = "application/json, text/javascript, */*";
                request.ContentType = "application/json; charset=utf-8";
                if (contentType != "")
                {
                    request.ContentType = contentType;
                }
                if (!string.IsNullOrWhiteSpace(cookie))
                {
                    request.Headers.Add("cookie", cookie);
                }
                byte[] buffer = encoding.GetBytes(body);
                request.ContentLength = buffer.Length;
                request.GetRequestStream().Write(buffer, 0, buffer.Length);
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                using StreamReader reader = new StreamReader(response.GetResponseStream(), encoding);
                result = reader.ReadToEnd();
            }
            catch (WebException ex)
            {
                LogHelper.WriteError("HttpPost", string.Format("HttpHelper_HttpPost：url:{0} body:{1} contentType:{2}", url, body, contentType), ex: ex);
            }
            return result;
        }


        /// <summary>
        /// 执行HTTP GET请求。
        /// </summary>
        /// <param name="url">请求地址</param>
        /// <returns>HTTP响应</returns>
        public static string HttpGet(string url)
        {
            string result = "";
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            req.Method = "GET";
            req.ContentType = "application/json";
            HttpWebResponse rsp = (HttpWebResponse)req.GetResponse();
            Encoding encoding = Encoding.UTF8;
            if (!string.IsNullOrWhiteSpace(rsp.CharacterSet))
            {
                encoding = Encoding.GetEncoding(rsp.CharacterSet);
            }
            Stream stream = null;
            StreamReader reader = null;
            try
            {
                // 以字符流的方式读取HTTP响应
                stream = rsp.GetResponseStream();
                reader = new StreamReader(stream, encoding);
                result = reader.ReadToEnd();
            }
            catch (Exception ex)
            {
                LogHelper.WriteError("HttpHelper_HttpGet", string.Format("url:{0}", url), ex);
                result = "";
            }
            finally
            {
                // 释放资源
                if (reader != null) reader.Close();
                if (stream != null) stream.Close();
                if (rsp != null) rsp.Close();
            }
            return result;
        }
    }
}