﻿using Newtonsoft.Json.Linq;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TicketSpider.Model;
using TicketSpider.Spiders.EasterLineRule;
using TicketSpider.Uitls;

namespace TicketSpider.Data
{
    public class FlightFlow
    {

        private JArray TARGET_FLIGHT = new JArray();

        public async void StartAsync()
        {
            
            Console.WriteLine("进入东航刷票模块，开始计算需求.......");
            
            Console.WriteLine("开始模拟登录信息.......");
            string loginCookies = AccountManagerHelper.GetInstance();
            if (!string.IsNullOrEmpty(loginCookies) && !TaskHelper.cancelTokenSource.IsCancellationRequested)
            {
                Console.WriteLine("获取登录信息成功, 开始操作乘客信息");
               
                await Task.Run(() => new PassengerHelper().RegistPassengerHandler());
                Thread.Sleep(2000);
                Console.WriteLine("乘客信息处理完毕，开始执行寻票...");
                if (CmdHelper.FLIGHTS.Count == 1) 
                {
                    if (CmdHelper.FLIGHTS.FirstOrDefault().DepartDateMode == 1)
                    {
                        Task.Factory.StartNew(() => QueryTicketHandler(CmdHelper.FLIGHTS.FirstOrDefault().DepartDate), TaskHelper.cancelTokenSource.Token);
                    }
                    else if (CmdHelper.FLIGHTS.FirstOrDefault().DepartDateMode == 2)
                    {
                        var dates=CmdHelper.FLIGHTS.FirstOrDefault().DepartDate.Split("~");
                        var dt1 = DateTime.Parse(dates[0]);
                        var dt2 = DateTime.Parse(dates[1]);
                        while (true)
                        {
                            Task.Factory.StartNew(() => QueryTicketHandler(dt1.ToString("yyyy-MM-dd")), TaskHelper.cancelTokenSource.Token);
                            dt1.AddDays(1);
                            if (dt1 > dt2) break;
                        }
                    }
                    else if (CmdHelper.FLIGHTS.FirstOrDefault().DepartDateMode == 3)
                    {
                        var dates = CmdHelper.FLIGHTS.FirstOrDefault().DepartDate;
                        var dt1 = DateTime.Parse($"{dates}-01");
                        while (true)
                        {
                            Task.Factory.StartNew(() => QueryTicketHandler(dt1.ToString("yyyy-MM-dd")), TaskHelper.cancelTokenSource.Token);
                            dt1.AddDays(1);
                            if (dt1.ToString("yyyy/MM") != dates) break;
                        }
                    }
                }
            }
            else 
            {
                Console.WriteLine("获取登录信息失败，程序退出...");
                Environment.Exit(0);
            }
            
        }

        public async void QueryTicketHandler(string date)
        {
            //Setup 2:获取航班数据
            var flight = new QueryFlightHelper(0.1M).RunAsync(date).Result;
            if (!TaskHelper.cancelTokenSource.IsCancellationRequested) return;
            Console.WriteLine("获取机票信息完毕");
            Thread.Sleep(1000);
            //Setup 4 创建订单
            Console.WriteLine("开始创建订单...");
            var orderSubmit = await new TicketOrderHelper().RunAsync(flight);
            if (!TaskHelper.cancelTokenSource.IsCancellationRequested) return;
            if (orderSubmit.result)
            {
                //Setup 5 弹出付款链接
                Console.WriteLine("订单创建成功，正在准备付款页面");
                OpenOrderPayPageHandler(orderSubmit.order);
            }
            else
            {
                Console.WriteLine("订单提交失败....程序退出");
                TaskHelper.GetInstance().UnLockOrderStatus(); //释放锁定
            }
        }

        public void OpenOrderPayPageHandler(JObject order)
        {
            var flag = false;
            ReadOnlyCollection<IWebElement> inputEle = null;
            var option = new ChromeOptions();
            //option.AddArgument("--incognito");
            //option.AddArgument("headless");
            option.AddArgument("disable-infobars");
            //option.AddArgument("window-size=1920,1080");
            //option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36");
            ChromeDriverService service = ChromeDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            IWebDriver driver = new ChromeDriver(service, option);
            var cookies = AccountManagerHelper.GetInstance().Split(";");
            driver.Navigate().GoToUrl("https://www.ceair.com/");
            Thread.Sleep(2000);
            driver.Manage().Cookies.DeleteAllCookies();
            foreach (var item in cookies)
            {
                driver.Manage().Cookies.AddCookie(new Cookie(item.Split("=")[0], item.Split("=")[1]));
            }
            var param= $"{{\"tdOrderNo\":\"{order["tdOrderNo"].ToString()}\",\"t\":{DateTime.Now.Ticks}}}";
            param = Convert.ToBase64String(Encoding.UTF8.GetBytes(param));
            param = System.Web.HttpUtility.UrlEncode(param);
            
            driver.Navigate().GoToUrl($"https://www.ceair.com/payment?searchKey={param}ENCODEKEY");
            //通知流程结束
            TaskHelper.cancelTokenSource.Cancel();
            AccountManagerHelper.StopHeartLine();
        }

    }
}
