﻿// See https://aka.ms/new-console-template for more information

using Newtonsoft.Json;
using TicketSpider.Data;
using TicketSpider.Model;
using TicketSpider.Spiders;
using TicketSpider.Uitls;

ThreadPool.SetMaxThreads(255, 255);
ThreadPool.SetMinThreads(255, 255);

#region 初始化城市信息
if (!CityService.Load()) 
{
    Console.WriteLine("初始化城市信息失败，检查相关文件");
    return;
}
#endregion

#region 航司选择
var airLines = new string[] { "E", "C" };
while (true)
{
    Console.WriteLine("请选择要执行的航司，E：东航；C：国航，多个航司使用英语逗号相隔（E,C）");
    var airlineStr = Console.ReadLine();
    if (!string.IsNullOrEmpty(airlineStr))
    {
        var airlineIpt = airlineStr.Split(",");
        var except = airlineIpt.Except(airLines);
        if (except == null || !except.Any())
        {
            CmdHelper.AIRLINE = airlineIpt;
            break;
        }
    }
    Console.WriteLine("输入有误，重新输入");
}
#endregion

#region 命令模式
while (true) 
{
    Console.WriteLine("请选择命令模式（1 步骤模式，2 命令行模式）");
    var modes = new int[] { 1,2};
    var mode = Console.ReadLine();
    if (!string.IsNullOrEmpty(mode)&&int.TryParse(mode,out CmdHelper.CMD_MODEL))
    {
        if (modes.Contains(CmdHelper.CMD_MODEL)) 
        {
            break;
        }
    }
    Console.WriteLine("输入有误，重新输入");
}
#endregion

#region 步骤命令模式
if (CmdHelper.CMD_MODEL == 1) 
{
    #region 输入航段
    while (true)
    {
        var model = new Flight();
        
        //出发与目的地
        while (true)
        {
            Console.WriteLine($"请输入航段{CmdHelper.FLIGHTS.Count() + 1}的出发城市与目的城市，使用'-'相隔。（成都-巴黎）");
            var cits = Console.ReadLine();
            if (!string.IsNullOrEmpty(cits) && cits.Split("-").Length == 2)
            {

                if (!CityService.Container(cits.Split("-")[0]))
                {
                    Console.WriteLine($"{cits.Split("-")[0]}，没有找到机场信息，请重新输入");
                }
                else if (!CityService.Container(cits.Split("-")[1]))
                {
                    Console.WriteLine($"{cits.Split("-")[1]}，没有找到机场信息，请重新输入");
                }
                else 
                {
                    model.DepartCity = cits.Split("-")[0];
                    model.ArriveCity = cits.Split("-")[1];
                     break;
                }
               
            }
            Console.WriteLine("输入错误，重新输入");
        }
        //日期
        while (true)
        {
            Console.WriteLine($"请输入航段{CmdHelper.FLIGHTS.Count() + 1}出发日期，（单日:2022/05/01,范围:2022/05/01-2022/07/01,月份:2022/07）");
            var dateStr = Console.ReadLine();
            var dtNow = DateTime.Now;
            if (dateStr.Contains("-") && dateStr.Split("-").Length == 2)
            {
                var dates = dateStr.Split("-");
               
                if (DateTime.TryParse(dates[0], out dtNow) && DateTime.TryParse(dates[1], out dtNow))
                {
                    model.DepartDate = dateStr.Replace("-","~");
                    model.DepartDateMode = 2;
                    break;
                }
            }
            else 
            {
                var dates = dateStr.Split("/");
                if ((dates.Length == 3 || dates.Length == 2) && DateTime.TryParse(dateStr, out dtNow)) 
                {
                    model.DepartDate = dateStr;
                    model.DepartDateMode = dates.Length == 3 ? 1 : 3;
                    break;
                }
            }
            Console.WriteLine("输入错误，重新输入");
        }
        //航班
        Console.WriteLine($"请输入航段{CmdHelper.FLIGHTS.Count() + 1}需要指定的航班（如：3U8633, 没有直接回车）");
        model.AirlineCode = Console.ReadLine() ?? string.Empty;
        Console.WriteLine($"请输入航段{CmdHelper.FLIGHTS.Count() + 1}需要指定的仓位代码，多个使用英文逗号相隔（如：\"Y\" \"C,Y\", 没有直接回车）");
        model.SeatCode= Console.ReadLine() ?? string.Empty;
        CmdHelper.FLIGHTS.Add(model);
        var isContinu = false;
        while (true)
        {
            Console.WriteLine($"航段{CmdHelper.FLIGHTS.Count()}添加成功，是否继续添加航段? (Y:继续添加/n:不添加)");
            var continu=Console.ReadLine()?? string.Empty;
            if (continu == "Y" || continu == "n")
            {
                isContinu = continu == "Y";
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }

        if (!isContinu) break;
    }
    #endregion

    #region 添加乘客
    while (true)
    {
        var model = new Passenger();
        while (true)
        {
            Console.WriteLine($"请输入乘客{CmdHelper.PASSENGETS.Count + 1}的英文姓名（LIU/DONG）");
            var name=Console.ReadLine()?? string.Empty;
            if (name.Split("/").Length == 2) 
            {
                model.paxNameFirst = name.Split("/")[0];
                model.paxNameLast = name.Split("/")[1];
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }
        while (true)
        {
            Console.WriteLine($"请输入乘客{CmdHelper.PASSENGETS.Count + 1}的性别（M 男，F 女）");
            var name = Console.ReadLine() ?? string.Empty;
            if (name == "M" || name == "F")
            {
                model.gender = name;
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }
        while (true)
        {
            Console.WriteLine($"请输入乘客{CmdHelper.PASSENGETS.Count + 1}生日 （2022/01/01）");
            var name = Console.ReadLine() ?? string.Empty;
            var dtnow=DateTime.Now;
            if (DateTime.TryParse(name,out dtnow))
            {
                model.birthday = name;
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }
        while (true)
        {
            Console.WriteLine($"请输入乘客{CmdHelper.PASSENGETS.Count + 1}联系电话 （13080808080）");
            var name = Console.ReadLine() ?? string.Empty;
            if (name.Length==11)
            {
                model.mobile = name;
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }
        while (true)
        {
            Console.WriteLine($"请输入乘客{CmdHelper.PASSENGETS.Count + 1}护照号和护照有效期 （EH36523023 2029/08/18）");
            var name = (Console.ReadLine() ?? string.Empty).Split(" ");
            var dtNow=DateTime.Now;
            if (name.Length == 2 && name[0].Length>6 && DateTime.TryParse(name[1],out dtNow))
            {
                model.favorPaxIdDtoList = new List<FavorPaxIdDtoList>() {
                    new FavorPaxIdDtoList()
                    {
                        idType="PP",
                        idNo=name[0],
                        paxYouxiaoqi=name[1]
                    }
                };
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }
        CmdHelper.PASSENGETS.Add(model);
        var isContinu = false;
        while (true)
        {
            Console.WriteLine($"乘客{CmdHelper.PASSENGETS.Count()}添加成功，是否继续添加乘客? (Y:继续添加/n:不添加)");
            var continu = Console.ReadLine() ?? string.Empty;
            if (continu == "Y" || continu == "n")
            {
                isContinu = continu == "Y";
                break;
            }
            Console.WriteLine("输入错误，重新输入");
        }

        if (!isContinu) break;
    }
    #endregion
}
#endregion 

#region 命令行模式
if (CmdHelper.CMD_MODEL == 2) 
{
    while (true)
    {
        Console.WriteLine("请输入命令行，如果需要帮助请输入“H”");
        var cmd = Console.ReadLine();

        if (cmd == "H")
        {
            while (true)
            {
                Console.WriteLine("请选择你需要的帮助信息序号：");
                Console.WriteLine("1. 单航段单人机票命令说明");
                Console.WriteLine("2. 单航段多人机票命令说明");
                Console.WriteLine("3. 多航段单人机票命令说明");
                Console.WriteLine("4. 多航段多人机票命令说明");
                Console.WriteLine("退出输入：“Q”");
                var input = Console.ReadLine();
                var keys = new string[] { "1", "2", "3", "4", "Q" };
                if (keys.Contains(input))
                {
                    if (input == "1")
                    {
                        Console.WriteLine("");
                        Console.WriteLine("");
                        Console.WriteLine("***************************单航段单人机票命令说明开始***************************");
                        Console.WriteLine("");
                        Console.WriteLine("指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31 3U8633 Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班，指定仓位：洛杉矶/北京 2022/05/01~2022/07/31  Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31  -LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("命令解析：出发地/目的地 出发日期 航班（不指定留空）仓位（不指定留空）-(表示链接乘客信息) 乘客英文名 性别 生日 电话 护照号 护照到期时间");
                        Console.WriteLine("");
                        Console.WriteLine("出发日期说明：单日:2022/05/01,范围:2022/05/01~2022/07/01,月份:2022/07");
                        Console.WriteLine("");
                        Console.WriteLine("注意：乘客信息务必准确，以防止开票信息不正确");
                        Console.WriteLine("");
                        Console.WriteLine("***************************单航段单人机票命令说明结束***************************");
                        Console.WriteLine("");
                    }
                    else if (input == "2")
                    {
                        Console.WriteLine("");
                        Console.WriteLine("");
                        Console.WriteLine("***************************单航段多人机票命令说明开始***************************");
                        Console.WriteLine("");
                        Console.WriteLine("指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31 3U8633 Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班，指定仓位：洛杉矶/北京 2022/05/01~2022/07/31  Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31  -LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("命令解析：出发地/目的地 出发日期 航班（不指定留空）仓位（不指定留空）-(表示链接乘客信息) 乘客英文名 性别 生日 电话 护照号 护照到期时间,(英文逗号后面继续按照相同格式添加乘客信息)");
                        Console.WriteLine("");
                        Console.WriteLine("出发日期说明：单日:2022/05/01,范围:2022/05/01~2022/07/01,月份:2022/07");
                        Console.WriteLine("");
                        Console.WriteLine("注意：乘客信息务必准确，以防止开票信息不正确");
                        Console.WriteLine("");
                        Console.WriteLine("***************************单航段多人机票命令说明结束***************************");
                        Console.WriteLine("");

                    }
                    else if (input == "3")
                    {
                        Console.WriteLine("");
                        Console.WriteLine("");
                        Console.WriteLine("***************************多航段航段单人机票命令说明开始***************************");
                        Console.WriteLine("");
                        Console.WriteLine("指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31 3U8633 Y,北京/成都 2022/05/01~2022/07/31 3U8633 Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班，指定仓位：洛杉矶/北京 2022/05/01~2022/07/31  Y,北京/成都 2022/05/01~2022/07/31  Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31  ,北京/成都 2022/05/01~2022/07/31  -LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18");
                        Console.WriteLine("");
                        Console.WriteLine("命令解析：出发地/目的地 出发日期 航班（不指定留空）仓位（不指定留空）,(英文逗号后面继续按照格式添加航班)-(表示链接乘客信息) 乘客英文名 性别 生日 电话 护照号 护照到期时间");
                        Console.WriteLine("");
                        Console.WriteLine("出发日期说明：单日:2022/05/01,范围:2022/05/01~2022/07/01,月份:2022/07");
                        Console.WriteLine("");
                        Console.WriteLine("注意：乘客信息务必准确，以防止开票信息不正确");
                        Console.WriteLine("");
                        Console.WriteLine("***************************多航段航段单人机票命令说明结束***************************");
                        Console.WriteLine("");
                    }
                    else if (input == "4")
                    {
                        Console.WriteLine("");
                        Console.WriteLine("");
                        Console.WriteLine("***************************多航段航段多人机票命令说明开始***************************");
                        Console.WriteLine("");
                        Console.WriteLine("指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31 3U8633 Y,北京/成都 2022/05/01~2022/07/31 3U8633 Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班，指定仓位：洛杉矶/北京 2022/05/01~2022/07/31  Y,北京/成都 2022/05/01~2022/07/31  Y-LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("不指定航班和仓位：洛杉矶/北京 2022/05/01~2022/07/31  ,北京/成都 2022/05/01~2022/07/31  -LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18,HUANG/KUI 男 1989/02/08 13551126755 EP0218030 2028/02/07");
                        Console.WriteLine("");
                        Console.WriteLine("命令解析：出发地/目的地 出发日期 航班（不指定留空）仓位（不指定留空）,(英文逗号后面继续按照格式添加航班)-(表示链接乘客信息) 乘客英文名 性别 生日 电话 护照号 护照到期时间,(英文逗号后面继续按照相同格式添加乘客信息)");
                        Console.WriteLine("");
                        Console.WriteLine("出发日期说明：单日:2022/05/01,范围:2022/05/01~2022/07/01,月份:2022/07");
                        Console.WriteLine("");
                        Console.WriteLine("注意：乘客信息务必准确，以防止开票信息不正确");
                        Console.WriteLine("");
                        Console.WriteLine("***************************多航段航段多人机票命令说明结束***************************");
                        Console.WriteLine("");
                    }
                    else
                    {
                        break;
                    }
                    Console.WriteLine("按任意键返回上级...");
                    Console.ReadKey();
                }
                else
                {
                    Console.WriteLine("输入错误，请重新输入");
                }

            }
        }
        else 
        {
            var cmds = cmd.Split("-");
            if (cmds.Length == 2) 
            {
                #region 解析航段

                var flights = cmds[0].Split(",");
                var flightList = new List<Flight>();
                foreach (var flight in flights)
                {
                    var flightInfo = flight.Split(" ");
                    if (flightInfo.Length == 4 && flightInfo[0].Split("/").Length==2)
                    {
                        //验证时间
                        var dtNow = DateTime.Now;
                        var flightModel = new Flight();
                        if (!CityService.Container(flightInfo[0].Split("/")[0]))
                        {
                            Console.WriteLine($"{flightInfo[0].Split("/")[0]}，没有找到机场信息，请重新输入");
                        }
                        else if (!CityService.Container(flightInfo[0].Split("/")[1]))
                        {
                            Console.WriteLine($"{flightInfo[0].Split("/")[1]}，没有找到机场信息，请重新输入");
                        }
                        else
                        {
                            flightModel.DepartCity = flightInfo[0].Split("/")[0];
                            flightModel.ArriveCity = flightInfo[0].Split("/")[1];

                            flightModel.AirlineCode = flightInfo[2];
                            flightModel.SeatCode = flightInfo[3];
                            var dateStr = flightInfo[1];
                            if (dateStr.Contains("~") && dateStr.Split("~").Length == 2)
                            {
                                var dates = dateStr.Split("~");
                                if (DateTime.TryParse(dates[0], out dtNow) && DateTime.TryParse(dates[1], out dtNow))
                                {
                                    flightModel.DepartDate = dateStr;
                                    flightModel.DepartDateMode = 2;
                                    flightList.Add(flightModel);
                                }
                            }
                            else
                            {
                                var dates = dateStr.Split("/");
                                if ((dates.Length == 3 || dates.Length == 2) && DateTime.TryParse(dateStr, out dtNow))
                                {
                                    flightModel.DepartDate = dateStr;
                                    flightModel.DepartDateMode = dates.Length == 3 ? 1 : 3;
                                    flightList.Add(flightModel);
                                }
                            }
                        }
                    }
                }

                #endregion

                #region 解析乘客信息
                var passengers = cmds[1].Split(",");
                var passengerList = new List<Passenger>();
                //LUO/CHAO 男 1990/12/26 17308037817 EP2020158 2028/05/18
                foreach (var passengerStr in passengers) 
                {
                    var pList = passengerStr.Split(" ");
                    if (pList.Length == 6) 
                    {
                        if (pList[0].Split("/").Length == 2 && (pList[1] == "男" || pList[1] == "女") && DateTime.TryParse(pList[2], out DateTime dt1) && pList[3].Length == 11 && pList[4].Length > 5 && DateTime.TryParse(pList[5], out DateTime dt2)) 
                        {
                            var passenger = new Passenger()
                            {
                                id = "",
                                paxName = "",
                                paxNameFirst = pList[0].Split("/")[0],
                                paxNameLast = pList[0].Split("/")[1],
                                gender = pList[1]=="男"?"M":"F",
                                birthday = pList[2].Replace("/",""),
                                nationality = "CN",
                                telephoneCode = "86",
                                mobile = pList[3],
                                email = "",
                                ffpAirline = "",
                                ffpNo = "",
                                favorPaxIdDtoList = new List<FavorPaxIdDtoList>() {
                                    new FavorPaxIdDtoList() {
                                        id="",
                                        favorPaxId="",
                                        idIssueNation="",
                                        idNo=pList[4],
                                        idType="PP",
                                        idValidDt=pList[5],
                                        paxIDType=""
                                    }
                                },
                                paxType = ""
                            };
                            passengerList.Add(passenger);
                        }
                    }
                }

                #endregion

                if (flightList.Count == flights.Length && passengerList.Count == passengers.Length) 
                {
                    var flightAllName = string.Empty;
                    var passNames = string.Empty;
                    flightList.ForEach(x => {
                        if (flightList.IndexOf(x) != flightList.Count - 1 || flightList.IndexOf(x)==0) flightAllName += "/" + x.DepartCity;
                        if (flightList.IndexOf(x) == flightList.Count - 1) flightAllName += "/" + x.ArriveCity;
                    });
                    passengerList.ForEach(x => {
                        passNames += "/" + x.paxNameFirst + x.paxNameLast;
                    });
                    Console.WriteLine($"刷票需求识别成功，本次行程为：{flightAllName.Remove(0,1)} {flightList.Count}段航程,本次乘客为：{passNames.Remove(0, 1)} {passengerList.Count}位乘客");
                    CmdHelper.FLIGHTS = flightList;
                    CmdHelper.PASSENGETS = passengerList;
                    break;
                }

                Console.WriteLine("命令有误，请检查后重新提交");
            }
        }
        Console.WriteLine("");
    }
}
#endregion

#region 初始化机场信息

CmdHelper.FLIGHTS.ForEach(x =>
{
    var cityDept = CityService.GetCityHandler(x.DepartCity);
    var cityArr = CityService.GetCityHandler(x.ArriveCity);
    x.depCityCode = cityDept.cityCode;
    x.depCode = cityDept.value;
    x.arrCityCode = cityArr.cityCode;
    x.arrCode = cityArr.value;
});

#endregion

//Task.Run(() => new FlightFlow().StartAsync());
if (CmdHelper.AIRLINE.Contains("E")) 
{
    Task.Factory.StartNew(() => new FlightFlow().StartAsync(), TaskHelper.cancelTokenSource.Token);
}
if (CmdHelper.AIRLINE.Contains("C"))
{
    Console.WriteLine("暂不支持国航机票嗅探");
}

Console.ReadLine();

Environment.Exit(0);