﻿using Newtonsoft.Json.Linq;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using OpenQA.Selenium.Interactions;
using OpenQA.Selenium.Remote;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Drawing;
using System.Drawing.Imaging;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace TicketSpider.Spiders.EasterLineRule
{
    public class AccountManagerHelper
    {

        private static object  lockerSafe= new object();

        private static string _loginCookies = null;

        private static bool _openHeartTimer = false;

        public static string _userId = String.Empty;

        public static string GetInstance()
        {
            if (_loginCookies == null)
            {
                lock (lockerSafe)
                {
                    if (_loginCookies == null) 
                    {
                        _loginCookies = string.Empty;
                        
                        var cnt = 0;
                        while (cnt<4)
                        {
                            cnt++;
                            var result = RunAsync();
                            if (result && !_openHeartTimer)
                            {
                                _openHeartTimer = true;
                                Task.Run(() => HeartLine());
                               
                                break;
                            }
                            else 
                            {
                                Console.WriteLine("开始重新尝试登录");
                                Thread.Sleep(2000);
                            }
                        }
                    }
                }  
            }
            return _loginCookies;
        }

        

        public static bool RunAsync()
        {
            var flag = false;
            ReadOnlyCollection<IWebElement> inputEle = null;
            var option = new ChromeOptions();
            option.AddArgument("--incognito");
            option.AddArgument("headless");
            option.AddArgument("disable-infobars");
            option.AddArgument("window-size=1920,1080");
            option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36");
            ChromeDriverService service = ChromeDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            IWebDriver driver = new ChromeDriver(service, option);
            
            try
            {
                
                driver.Navigate().GoToUrl($"https://sso.ceair.com/login/?type=ffp&redirectUrl=https%3A%2F%2Fwww.ceair.com%2F&lang=zh_CN");
                driver.Manage().Timeouts().PageLoad=TimeSpan.FromSeconds(15);

                inputEle = driver.FindElements(By.TagName("input"));
                
                if (inputEle != null && inputEle.Count > 0) 
                {
                    inputEle[0].SendKeys("17308037817");
                    inputEle[1].SendKeys("36925814");
                    var loginCount = 0;
                    //开始模拟登录
                    while (true)
                    {
                        loginCount++;
                        Console.WriteLine($"正在进行第{loginCount}次模拟登录...");
                        var login = BeginSliderLoginHandler(driver);
                        if (login.IsCompleted)
                        {
                            Console.WriteLine($"操作完成，正在等待结果");
                            //睡眠1秒，等待跳转
                            Thread.Sleep(1 * 1000);
                            
                            if (driver.Url.Contains("sso.ceair.com/login"))
                            {
                                Console.WriteLine($"模拟登录失败，准备重新执行...");
                                IWebElement silderBoxEle = null;
                                try
                                {
                                    driver.FindElement(By.CssSelector(".geetest_popup_ghost"));
                                }
                                catch (Exception){}
                                if (silderBoxEle != null)
                                {
                                    silderBoxEle.Click();
                                }
                                if (loginCount == 4)
                                {
                                    Console.WriteLine("连续4次失败，请检查账号密码是否正确，系统执行完毕");
                                    break;
                                }
                            }
                            else
                            {
                                //处理
                                foreach (var item in driver.Manage().Cookies.AllCookies)
                                {
                                    _loginCookies += item.Name + "=" + item.Value + ";";
                                }
                                _loginCookies = _loginCookies.Substring(0, _loginCookies.Length - 1);
                                var jscript = (IJavaScriptExecutor)driver;
                                var userInfo = JObject.Parse((string)jscript.ExecuteScript("return window.sessionStorage.getItem('user')"));
                                _userId = userInfo["userId"].ToString();
                                
                                flag = true;
                                break;
                            }
                        }
                        else 
                        {
                            Console.WriteLine("未知异常，程序退出");
                            break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"获取cooki失败，{ex.Message}");
            }
            driver.Quit();
            return flag;
            
        }

        public static Task BeginSliderLoginHandler(IWebDriver driver)
        {
            var buttonEle = driver.FindElement(By.CssSelector(".global-login-btn"));
            Thread.Sleep(1000);
            //开始登录
            buttonEle.Click();
            //等待滑块加载
            Thread.Sleep(2000);
            var bgCanvas = driver.FindElement(By.CssSelector(".geetest_window"));
            ((IJavaScriptExecutor)driver).ExecuteScript("document.querySelector(\".geetest_canvas_bg\").style.opacity = 1;document.querySelector(\".geetest_canvas_slice\").style.opacity = 0;");
            var bgPng = ((ITakesScreenshot)bgCanvas).GetScreenshot();
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            if (!Directory.Exists(dirpath))
            {
                Directory.CreateDirectory(dirpath);
            }
            var filePath = $"{dirpath}\\{DateTime.Now.Ticks}.png";
            bgPng.SaveAsFile(filePath, ScreenshotImageFormat.Png);
            using (Bitmap? bitmap = (Bitmap)Image.FromFile(filePath))
            {
                var grey = GetGrey(bitmap) / 10 * 3;
                var bgX = GetBoundary(bitmap, grey) - 8;
                Console.WriteLine($"读取背景缺口边界X坐标： {bgX}");

                Actions action = new Actions(driver);
                var sliderButton = driver.FindElement(By.CssSelector(".geetest_slider_button"));
                if (sliderButton != null)
                {
                    ((IJavaScriptExecutor)driver).ExecuteScript("document.querySelector(\".geetest_canvas_bg\").style.opacity = 1;document.querySelector(\".geetest_canvas_slice\").style.opacity = 1;");
                    action.ClickAndHold(sliderButton).Build().Perform();
                    #region 开始拟人移动
                    var d1 = Math.Round(bgX * 0.8);
                    var d2 = Math.Round(bgX * 0.1);
                    var d3 = Math.Round(bgX * 0.1);
                    action.MoveByOffset((int)d1, 1);
                    Thread.Sleep(new Random().Next(100) + 150);
                    action.MoveByOffset((int)d2, 1);
                    Thread.Sleep(new Random().Next(100) + 150);
                    action.MoveByOffset((int)d3, 1);
                    action.MoveByOffset((bgX - (int)d1 - (int)d2 - (int)d3), 1);
                    Thread.Sleep(2000);
                    #endregion
                    action.Release(sliderButton);
                    action.Build().Perform();
                    Thread.Sleep(5000);

                }
            }
            File.Delete(filePath);
            return Task.CompletedTask;
        }

        private static int GetGrey(Bitmap bmpobj)
        {
            var rgb = 0;
            for (int i = 0; i < bmpobj.Width; i++)
            {
                for (int j = 0; j < bmpobj.Height; j++)
                {
                    var currentColor = bmpobj.GetPixel(i, j);
                    var r = currentColor.R + currentColor.G + currentColor.B;
                    rgb += r;
                }
            }
            return rgb / (bmpobj.Width * bmpobj.Height);
        }

        private static int GetBoundary(Bitmap bitmap, int level) 
        {
            int lastY = 0, count = 0, outBoundary=0;
            for (int i = 0; i < bitmap.Width; i++)
            {
                for (int j = 0; j < bitmap.Height; j++)
                {
                    var currentColor = bitmap.GetPixel(i, j);
                    var r = currentColor.R + currentColor.G + currentColor.B;
                    if (r < level && lastY + 1 == j)
                    {
                        count++;
                    }
                    else 
                    {
                        count = 0;
                    }
                    lastY = j;
                    if (count > 6) 
                    {
                        outBoundary = i;
                        break;
                    }
                }
                if (outBoundary > 0) 
                {
                    break;
                }
            }
            return outBoundary;
        }

        private static void HeartLine()
        {
            while (_openHeartTimer)
            {
                var handler = new HttpClientHandler();
                handler.AllowAutoRedirect = false;
                handler.UseCookies = true;
                handler.CookieContainer = CreateCookie();
                handler.AutomaticDecompression = DecompressionMethods.GZip;
                handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
                var http = new HttpClient(handler);
                http.GetAsync("https://www.ceair.com/");
                //TODO:检查是否需要重新登录

                Thread.Sleep(60 * 1000);
            }
        }

        public static void StopHeartLine()
        { 
            _openHeartTimer = false;
        }

        private static CookieContainer CreateCookie()
        {
            var uri = new Uri("https://www.ceair.com");
            var cc = new CookieContainer();
            foreach (var str in _loginCookies.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }
    }
}
