﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using TicketSpider.Model;
using TicketSpider.Uitls;

namespace TicketSpider.Spiders.EasterLineRule
{
    public class PassengerHelper
    {
        public static List<Passenger> GLOBAL_USERLIST { get; private set; }

        public async void RegistPassengerHandler()
        {
            GLOBAL_USERLIST = new List<Passenger>();
            var registResult = await RegistPassenger(CmdHelper.PASSENGETS);
            var passengersArray = await IsHavePassenger();
            if (passengersArray.Any())
            {
                var passengers = passengersArray.ToObject<List<Passenger>>();
                CmdHelper.PASSENGETS.ForEach(user => {
                    passengers.ToList().ForEach(x => {
                        x.favorPaxIdDtoList.ForEach(y =>
                        {
                            if (y.idType == user.favorPaxIdDtoList.First().idType && y.idNo == user.favorPaxIdDtoList.First().idNo)
                            {
                                y.idValidDt=user.favorPaxIdDtoList[0].idValidDt;
                                GLOBAL_USERLIST.Add(x);
                                
                            }
                        });
                    });
                });
                if (GLOBAL_USERLIST.Any())
                {
                    Console.WriteLine("完成乘客信息锁定");
                }
                else 
                {
                    Console.WriteLine("警告：未能绑定乘客信息");
                }
            }
            else 
            {
                Console.WriteLine("警告：未能绑定乘客信息");
            }
        }

        private async Task<bool> RegistPassenger(List<Passenger> userList)
        {
            JObject passengers = new JObject();
            passengers.Add("paxs", JArray.FromObject(userList));
            passengers.Add("singleAlone",false);
            passengers.Add("deviceId", "");

            var paramster=JsonConvert.SerializeObject(passengers);
            var request = CreateRequest();
            var url = "https://www.ceair.com/portal/v3/customer/addPassenger";
            var content = new StringContent(paramster, System.Text.Encoding.UTF8, "application/json");
             var response = await request.PostAsync(url, content);

            var result = response.Content.ReadAsStringAsync().Result;
            if (result.Contains("A200") || result.Contains("U200127"))
            {
                return true;
            }

            return false;
        }

        private async Task<JArray> IsHavePassenger() 
        {
            var request = CreateRequest();
            var resloveResult = new JArray();
            var url = "https://www.ceair.com/portal/v3/customer/queryPassengerList";
            var content = new StringContent("{\"userId\": " + AccountManagerHelper._userId+ ", \"deviceId\": \"\"}", System.Text.Encoding.UTF8, "application/json");
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (result.Contains("U200"))
            {
                
                try
                {
                    resloveResult = JObject.Parse(result)["resultContent"]as JArray;
                }
                catch (Exception) { }
            }
            //if (resloveResult.Any()) 
            //{
            //    Console.WriteLine($"获取乘客信息成功：{JsonConvert.SerializeObject(resloveResult)}");
            //}
            return resloveResult;
        }

        private HttpClient CreateRequest()
        {
            var handler = new HttpClientHandler();
            handler.AllowAutoRedirect = false;
            handler.UseCookies = true;
            handler.CookieContainer = CreateCookie(AccountManagerHelper.GetInstance());
            handler.AutomaticDecompression = DecompressionMethods.GZip;
            handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
            var http = new HttpClient(handler);
            CreateRequestHeaders(ref http);

            return http;
        }

        private CookieContainer CreateCookie(string cookieStr)
        {
            var uri = new Uri("https://www.ceair.com");
            var cc = new CookieContainer();
            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }

        private void CreateRequestHeaders(ref HttpClient http)
        {
            var random = new Random();
            http.DefaultRequestHeaders.Add("Accept", "application/json, text/plain, */*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            //http.DefaultRequestHeaders.Add("Connection", "keep-alive");
            //http.DefaultRequestHeaders.Add("Content-Length", "188");
            //http.DefaultRequestHeaders.Add("Content-Type", new MediaTypeHeaderValue("application/json"));
            //http.DefaultRequestHeaders.Add("Host", "m.ceair.com");
            http.DefaultRequestHeaders.Add("Origin", "https://www.ceair.com");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://www.ceair.com/leftNavigation/personCenter/passengers");
            //http.DefaultRequestHeaders.Add("salesChannel", "NzcwMQ==");
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");
            http.DefaultRequestHeaders.Add("x-tingyun-id", $"DuR5xFLm8eI;r={random.Next(100000000, 999999999)}");

            http.DefaultRequestHeaders.Add("site", "zh_CN");
            http.DefaultRequestHeaders.Add("shakehand", "535206fb27efbaf75066ff179b975ff6");
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }
    }
}
