﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 学员相关信息控制器
    /// </summary>
    public class StuController : BaseController
    {
        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetStuCourse()
        {
            var query = new Model.Query.CourseQuery()
            {
                StuIds = base.BaseUserId.ToString()
            };
            var list = CourseService.GetStuCourseList(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取学员作业和考试信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]

        public ApiResult GetStuWork()
        {
            var query = new Model.Query.CourseQuery()
            {
                StuIds = base.BaseUserId.ToString(),
                courseId = base.ReqParameters.GetInt("courseId")
            };
            var homeworkExamList = CourseService.GetStuWorkAndExamList(query);
            return ApiResult.Success(data: homeworkExamList);
        }
    }
}
