﻿using EduSpider.Cache.User;
using EduSpider.Model.Cache;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using System;
using VTX.FW.Helper;
using VTX.FW.VtController;

namespace EduSpider.WebApi.Controllers.Base
{
    [EnableCors("AllowCors")]
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class BaseController : ApiBaseController
    {
        /// <summary>
        /// 获取用户编号
        /// </summary>
        public int BaseUserId
        {
            get
            {
                int UserId = 0;
                if (!string.IsNullOrEmpty(base.RequestParm.Token))
                {
                    var jObj = VTX.FW.Helper.JwtHelper.AnalysisToken(base.RequestParm.Token);
                    if (jObj != null)
                    {
                        UserId = jObj.GetInt("BaseUserId");
                    }
                }
                return UserId;
            }
        }

        /// <summary>
        /// 获取登录信息
        /// </summary>
        public UserInfo UserInfo
        {
            get
            {
                return UserReidsCache.GetUserLoginInfo(this.BaseUserId);                
            }
        }
    }
}
