﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Mvc;
using System.Collections.Generic;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 老师相关控制器
    /// </summary>
    public class TeacherController : BaseController
    {
        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetTeacherCourse()
        {
            var query = new Model.Query.CourseQuery()
            {
                TeacherIds = base.BaseUserId.ToString()
            };
            //全部课程
            List<object> AllCourseList = new();
            //已结课
            List<object> FinishList = new();
            //进行中
            List<object> NotFinishList = new();
            var list = CourseService.GetTeacherCourseList(query);
           
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    var obj = new
                    {
                        item.courseId,
                        item.CourseName,
                        item.CoverImg,
                        item.CompleteNum,
                        item.TotalClassNum,
                        item.TeacherName,
                    };
                    AllCourseList.Add(obj);
                    if (item.CourseStatus == 3)
                    {
                        FinishList.Add(obj);
                    }
                    if (item.CourseStatus == 1 && item.CompleteNum != item.TotalClassNum)
                    {
                        NotFinishList.Add(obj);
                    }
                }
            }
            var result = new { AllCourseList, FinishList, NotFinishList };
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程学员列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]

        public ApiResult GetCourseStu()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            List<object> result = new();
            var list = CourseService.GetStuCourseList(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    result.Add(new
                    {
                        StuId = item.uid,
                        StuName = item.name,
                        StuAccount = item.account
                    });
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]

        public ApiResult GetCourseHomeWork()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            var list = CourseService.GetCourseHomeWork(query);
            return ApiResult.Success(data: list);
        }
    }
}
