﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace TicketSpider.Spiders.EasterLineRule
{
    public class QueryFlightHelper
    {
        private static decimal REQUEST_QPS=2;

        private static int INTERVAL_TIMER = 1000;

        //public CookieContainer cookieContainer = new CookieContainer();

        public QueryFlightHelper(decimal qps = 2) 
        {
            REQUEST_QPS = qps;
            INTERVAL_TIMER = (int)(1000 / REQUEST_QPS);

        }

        public async Task<JObject> RunAsync(string date)
        {
            var timerCount = 1;
            var flightResult = new JObject();
            var cookieContainer = new CookieContainer();
            CreateCookie(ref cookieContainer);
            while (!TaskHelper.cancelTokenSource.IsCancellationRequested)
            {
                
                Console.WriteLine($"正在执行第{timerCount}次航班查询请求");
                var result = await Action(date,cookieContainer);
                timerCount++;
                if (result.result.Contains("S200"))
                {
                    var resloveResult = new JArray();
                    try
                    {
                        resloveResult= JObject.Parse(result.result)["data"]["flightItems"] as JArray;
                        var realFlight = resloveResult.ToList().Where(x => (x["cabinInfoDescs"] as JArray).Any());
                        if (realFlight.Any())
                        {
                            resloveResult = JArray.FromObject(realFlight);
                        }
                        else 
                        {
                            resloveResult.Clear();
                        }
                    }
                    catch (Exception){}
                    if (resloveResult.Any()) 
                    {
                        while (!TaskHelper.GetInstance().UpdateTicketStatus() && !TaskHelper.cancelTokenSource.IsCancellationRequested)
                        {
                            Console.WriteLine("已获取到机票信息，排队中，等待其他线程释放");
                            Thread.Sleep(1000);
                        }
                        if (TaskHelper.cancelTokenSource.IsCancellationRequested) break;
                        flightResult = JObject.Parse(result.result);
                        flightResult["data"]["flightItems"] = resloveResult;
                        break;
                    }
                }
                else 
                {
                    Console.WriteLine("未找到机票");

                    //var newCookies = result.cookies.Split(';',StringSplitOptions.RemoveEmptyEntries);
                    //if (newCookies.Any()) 
                    //{
                    //    var uri = new Uri("https://www.ceair.com");
                    //    foreach (var cookie in newCookies)
                    //    {
                    //        var haveCookies = cookieContainer.GetAllCookies().Where(x => x.Name == cookie.Split("=")[0]);
                    //        if (haveCookies.Any())
                    //        {
                    //            haveCookies.First().Value = cookie.Split("=")[1];
                    //        }
                    //        else
                    //        {
                    //            cookieContainer.SetCookies(uri, cookie);
                    //        }
                    //    }
                    //}
                    
                    //TODO 切换代理
                }
                Thread.Sleep(INTERVAL_TIMER);
            }
            //Console.WriteLine($"获取到航班数据");
            return flightResult;
        }

        public async Task<(string result,string cookies)> Action(string date,CookieContainer cookieContainer)
        {
            var result = string.Empty;
            var cookies = string.Empty;
            try
            {
                var handler = new HttpClientHandler();
                handler.AllowAutoRedirect = false;
                handler.UseCookies = true;
                handler.CookieContainer = cookieContainer;
                handler.AutomaticDecompression = DecompressionMethods.GZip;
                handler.ClientCertificateOptions = ClientCertificateOption.Automatic;
                var http = new HttpClient(handler);
                CreateRequestHeaders(ref http);
                var url = "https://www.ceair.com/portal/v3/shopping/briefInfo";
                var f = CmdHelper.FLIGHTS.FirstOrDefault();
                var paramStr = $"{{\"adultCount\":1,\"arrCityCode\":\"{f.arrCityCode}\",\"arrCode\":\"{f.arrCode}\",\"arrDate\":\"\",\"childCount\":0,\"depCityCode\":\"{f.depCityCode}\",\"depCode\":\"{f.depCode}\",\"depDate\":\"{date.Replace("/","-")}\",\"infantCount\":0,\"routeType\":\"OW\",\"onlyPlaneFlag\":false,\"cabinLevel\":\"\",\"deviceId\":\"\"}}";
                var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/json");
                var response = await http.PostAsync(url, content);
                //var setCookies = response.Headers.GetValues("Set-Cookie");
                
                //foreach (var item in setCookies)
                //{
                //    cookies += item + ";";
                //}
                result = response.Content.ReadAsStringAsync().Result;
            }
            catch (Exception e)
            {
                Console.WriteLine($"查询航班发生异常，异常信息如下：{e.Message}");
            }
            //FlightDataHelper.TARGET_FLIGHT=resu
            return (result,cookies);
        }

        private void CreateCookie(ref CookieContainer cookieContainer)
        {
            var cookieStr = new CookiesHelper().GetInitCookie().Result;
            var uri = new Uri("https://www.ceair.com");
            var cc = new CookieContainer();
            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            cookieContainer = cc;
        }

        private void CreateRequestHeaders(ref HttpClient http)
        {
            var random = new Random();
            http.DefaultRequestHeaders.Add("Accept", "application/json, text/plain, */*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            //http.DefaultRequestHeaders.Add("Connection", "keep-alive");
            //http.DefaultRequestHeaders.Add("Content-Length", "188");
            //http.DefaultRequestHeaders.Add("Content-Type", new MediaTypeHeaderValue("application/json"));
            //http.DefaultRequestHeaders.Add("Host", "m.ceair.com");
            http.DefaultRequestHeaders.Add("Origin", "https://www.ceair.com");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://www.ceair.com/shopping?searchKey=JTdCJTIydHJhdmVsVHlwZSUyMiUzQSUyMm9uZXdheSUyMiUyQyUyMnBhc3Nlbmdlck51bSUyMiUzQSUyMjElMkMwJTJDMCUyMiUyQyUyMmRlcENpdHklMjIlM0ElMjJCS0slMjIlMkMlMjJhcnJDaXR5JTIyJTNBJTIyU0hBJTIyJTJDJTIyZGVwVmFsdWVzJTIyJTNBJTIyQktLJTIyJTJDJTIyYXJyVmFsdWVzJTIyJTNBJTIyUFZHJTJDU0hBJTIyJTJDJTIyZGVwQ2l0eU5hbWUlMjIlM0ElMjIlRTYlOUIlQkMlRTglQjAlQjclMjIlMkMlMjJhcnJDaXR5TmFtZSUyMiUzQSUyMiVFNCVCOCU4QSVFNiVCNSVCNyUyMiUyQyUyMmRhdGUlMjIlM0ElMjIyMDIyLTEyLTExJTIyJTJDJTIyY2FiaW5DbGFzcyUyMiUzQSUyMkFMTCUyMiUyQyUyMnBheVdheSUyMiUzQSUyMm1vbmV5JTIyJTJDJTIyZGVwU2VsZWN0VmFsdWUlMjIlM0ElMjJCS0slMjIlMkMlMjJhcnJTZWxlY3RWYWx1ZSUyMiUzQSUyMlBWRyUyQ1NIQSUyMiUyQyUyMmRlcExhYmVsJTIyJTNBJTIyJTIyJTJDJTIyYXJyTGFiZWwlMjIlM0ElMjIlMjIlMkMlMjJpc0FyckNpdHklMjIlM0F0cnVlJTJDJTIyaXNEZXBDaXR5JTIyJTNBdHJ1ZSUyQyUyMmFyckNuJTIyJTNBJTIyQ04lMjIlMkMlMjJkZXBDbiUyMiUzQSUyMlRIJTIyJTJDJTIydCUyMiUzQTE2NTA4NzYwOTA5MjAlN0Q%3DENCODEKEY");
            http.DefaultRequestHeaders.Add("salesChannel", "NzcwMQ==");
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");
            

            http.DefaultRequestHeaders.Add("site", "zh_CN");
            http.DefaultRequestHeaders.Add("shakehand", "535206fb27efbaf75066ff179b975ff6");
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }
    }
}
