﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Config;

namespace EduSpider.IServices
{
    /// <summary>
    /// 课程服务层接口
    /// </summary>
    public interface ICourseService : IDependency
    {
        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCoursePage(int pageIndex, int pageSize, out long rowsCount, CourseQuery query);

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCourseList(CourseQuery query);
    }
}
