﻿using EduSpider.Spiders.ClassInRule;
using System;
using System.Threading;

namespace TicketSpider.Spiders.ClassInRule
{
    public class ClassInFlow
    {
        /// <summary>
        /// 导入ClassIn数据
        /// </summary>
        public void StartAsync()
        {
            VTX.FW.Helper.LogHelper.WriteInfo("RunClassInData", "开始ClassIn数据");
            Console.WriteLine("开始模拟登录信息.......");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始模拟登录信息.......");
            string loginCookies = VTX.FW.Helper.ConfigHelper.GetAppsettings("DefaultToken");
            //自定获取Cookie
            if (string.IsNullOrEmpty(loginCookies))
            {
                ClassInAccountManager.ClearCookie();
                loginCookies = ClassInAccountManager.GetInstance();
            }
            
            Console.WriteLine("cookies:" + loginCookies);
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "cookies：" + loginCookies);

            Console.WriteLine("开始获取老师信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取老师信息");
            TeacherManager.RunTeacher(loginCookies);
            Console.WriteLine("老师信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "老师信息更新结束");

            Console.WriteLine("开始获取学生信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取学生信息");
            StudentManager.RunAsync(loginCookies);
            Console.WriteLine("学生信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "学生信息更新结束");

            Console.WriteLine("开始获取课程信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取课程信息");
            CourseManager.RunCourse(loginCookies);
            Console.WriteLine("课程信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "课程信息更新结束");

            Console.WriteLine("开始获取作业信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始获取作业信息");
            HomeWorkManager.RunHomeWork(loginCookies);
            Console.WriteLine("作业信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "作业信息更新结束");

            Console.WriteLine("开始获取测验信息");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "开始测验信息");
            QuestionManager.RunHomeWork(loginCookies);
            Console.WriteLine("测验信息更新结束");
            VTX.FW.Helper.LogHelper.WriteInfo("StartAsync", "测验信息更新结束");
        }
    }
}
