﻿using EduSpider.Helpers;
using EduSpider.Model.Entity;
using EduSpider.Repository;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using VTX.FW;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    public class StudentManager
    {
        public async void RunAsync()
        {
            var request = EduSpider.Helpers.HttpHelper.GenerateHttp();
            var paramStr = "page=1&perpage=20&isdel=0";
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getSchoolStudentListByPage", content);

            var result = response.Content.ReadAsStringAsync().Result;
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        public async void RunCourse()
        {
            var request = EduSpider.Helpers.HttpHelper.GenerateHttp();
            var paramStr = "page=1&perpage=20&courseState=1";
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            var response = await request.PostAsync("https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList", content);

            var result = response.Content.ReadAsStringAsync().Result;
            List<RB_Course> list = new List<RB_Course>();
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("totalCourseNum");
                    JArray courseArray = JArray.Parse(dataObj.GetString("courseList"));
                    if (courseArray != null && courseArray.Count > 0)
                    {
                        foreach (var jItem in courseArray)
                        {
                            JObject courseObj = JObject.Parse(jItem.ToString());
                            list.Add(new RB_Course()
                            {
                                courseId = courseObj.GetInt("courseId"),
                                courseName=courseObj.GetString("courseName"),
                                beginTime=courseObj.GetInt("beginTime"),

                            });
                        }
                    }
                }
            }
            ICourseRepository courseRepository = new CourseRepository();
            courseRepository.BatchSetCourse(list);
            Console.WriteLine("result", result);
        }


    }
}
