﻿using EduSpider.IServices;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using System.Collections.Generic;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 学员相关信息控制器
    /// </summary>
    public class StuController : BaseController
    {
        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetStuCourse()
        {
            var userInfo = base.UserInfo;
            var query = new Model.Query.CourseQuery()
            {
                StuIds = userInfo.Id.ToString()
            };
            List<object> result = new();
            var list = CourseService.GetStuCourseList(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    result.Add(new
                    {
                        item.courseId,
                        item.CourseName,
                        item.CoverImg,
                        item.CompleteNum,
                        item.TotalClassNum,
                        item.TeacherName,
                    });
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取学员作业和考试信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]

        public ApiResult GetStuWork()
        {
            var query = new Model.Query.CourseQuery()
            {
                StuIds = base.ReqParameters.GetInt("stuId")!=0? base.ReqParameters.GetInt("stuId").ToString() :base.UserInfo.AccountId.ToString(),
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            var homeworkExamList = CourseService.GetStuWorkAndExamList(query);
            return ApiResult.Success(data: homeworkExamList);
        }

        
    }
}
