﻿using EduSpider.Utility.Plugin;
using OpenCvSharp;
using OpenQA.Selenium;
using OpenQA.Selenium.Firefox;
using OpenQA.Selenium.Interactions;
using OpenQA.Selenium.Support.UI;
using System;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Runtime.InteropServices;
using System.Threading;
using System.Threading.Tasks;

namespace TicketSpider.Spiders.ClassInRule
{
    public class ClassInAccountManager
    {

        private static readonly object lockerSafe = new();

        private static string _loginCookies = "";//"locationArgumentLang=zh-CN; sensorsdata2015jssdkcross={\"distinct_id\":\"12780052\",\"first_id\":\"180e074a47f92f-06489d0bb8915b-6b3e555b-1327104-180e074a4805d2\",\"props\":{\"$latest_traffic_source_type\":\"直接流量\",\"$latest_search_keyword\":\"未取到值_直接打开\",\"$latest_referrer\":\"\"},\"$device_id\":\"180e074a47f92f-06489d0bb8915b-6b3e555b-1327104-180e074a4805d2\"}; _eeos_uid=12780052; _eeos_useraccount=18140082327; _eeos_userlogo=/upload/images/20200126/709df9532bee722f2268_70.jpg; _eeos_domain=.eeo.cn; _eeos_sid=12780052; _eeos_nsid=kspGu2gfMu+U2EFgLpSGyg==; __tk_id=5792ca4f7a6655c40c4431fbdb729da4; PHPSESSID=l5aanmebp5lvpcbg630ccfha37; _eeos_traffic=EqlIOFq4S2hz5FTTtHzNUViBYcWCixrJYMCF6Y5yJuD8eq8ZwPvVSHMvUkLFA5lzNoaTrDBpGhEY7ykZ9lwMAsNJoNiDt2xKQBr9csRmiBE=";

        private static bool _openHeartTimer = false;

        public static string _userId = String.Empty;

        public static void ClearCookie()
        {
            _loginCookies = "";
        }

        public static string GetInstance()
        {
            if (string.IsNullOrEmpty(_loginCookies))
            {
                lock (lockerSafe)
                {
                    if (string.IsNullOrEmpty(_loginCookies))
                    {
                        _loginCookies = string.Empty;
                        var cnt = 0;
                        Random r = new Random();
                        while (cnt < 4)
                        {
                            cnt++;
                            int num = r.Next(1, 10);
                            Thread.Sleep(1000 * num);
                            var result = RunAsync();
                            if (result && !_openHeartTimer)
                            {
                                _openHeartTimer = true;
                                Task.Run(() => HeartLine());
                                break;
                            }
                            else
                            {
                                InfoHelper.WriteLine("开始重新尝试登录");
                                VTX.FW.Helper.LogHelper.WriteInfo("GetInstance", "开始重新尝试登录");
                                Thread.Sleep(2000);
                            }
                        }
                    }
                }
            }
            return _loginCookies;
        }

        public static bool RunAsync()
        {
            var flag = false;
            
            var option = new FirefoxOptions();
            option.AddArgument("--incognito");
            string IsOpenChrome = VTX.FW.Helper.ConfigHelper.GetAppsettings("IsOpenChrome");
            if (IsOpenChrome == "1")
            {
                option.AddArgument("window-size=1920,1080");
            }
            else
            {
                //google隐身模式
                //option.AddArgument("headless");
                //火狐隐身模式
                option.AddArgument("--headless");
                //option.AddArgument("--disable-gpu");
                // option.AddArgument("ingore-certificat                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    e-errors");
            }
            option.AddArgument("--disable-infobars");
            option.AddArgument("window-size=1920*1080");
            // option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:104.0) Gecko/20100101 Firefox/104.0");
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            FirefoxDriverService service = FirefoxDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            using (IWebDriver driver = new FirefoxDriver(service, option))
            {
                VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", "开始登录");
                try
                {
                    driver.Navigate().GoToUrl($"https://www.eeo.cn/cn/login");
                    ITimeouts timeouts = driver.Manage().Timeouts();
                    //设置查找元素最大超时时间为30秒
                    timeouts.ImplicitWait = new TimeSpan(0, 0, 30);
                    //设置页面操作最大超时时间为30秒
                    timeouts.PageLoad = new TimeSpan(0, 0, 30);
                    //设置脚本异步最大超时时间为30秒
                    timeouts.AsynchronousJavaScript = new TimeSpan(0, 0, 30);
                    //等待页面元素加载完成
                    //默认等待100秒
                    WebDriverWait wait = new WebDriverWait(driver, TimeSpan.FromSeconds(100));
                    IWebElement inputEle;
                    IWebElement pwdEle;
                    try
                    {
                        //等待页面上按钮加载
                        inputEle = wait.Until((d) =>
                        {
                            return d.FindElement(By.Name("phoneNum"));
                        });
                        pwdEle = wait.Until((d) =>
                        {
                            return d.FindElement(By.Name("loginPwd"));
                        });
                        if (inputEle != null && pwdEle != null)
                        {
                            inputEle.SendKeys("18140082327");
                            pwdEle.SendKeys("ls123456");
                        }
                    }
                    catch (Exception ex)
                    {
                        InfoHelper.WriteLine("未知异常，程序退出");
                        VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"未知异常，程序退出");

                    }
                    var buttonEle = driver.FindElement(By.CssSelector(".submit-btn"));
                    Thread.Sleep(1000);
                    //开始登录
                    buttonEle.Click();
                    //开始模拟登录
                    Random r = new Random();
                    for (var loginCount = 1; loginCount <= 2; loginCount++)
                    {
                        if (loginCount > 1)
                        {
                            int num = r.Next(1, 10);
                            Thread.Sleep(1000 * num);
                        }
                        InfoHelper.WriteLine($"正在进行第{loginCount}次模拟登录...");
                        VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"正在进行第{loginCount}次模拟登录...");
                        var login = FireFoxBeginSliderLoginHandler(driver);
                        if (login.IsCompleted)
                        {
                            driver.SwitchTo().DefaultContent();
                            Thread.Sleep(5 * 1000);
                            var cookies = driver.Manage().Cookies.AllCookies;
                            InfoHelper.WriteLine($"操作完成，正在等待结果");
                            VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"操作完成，正在等待结果");
                            //处理
                            foreach (var item in cookies)
                            {
                                _loginCookies += item.Name + "=" + item.Value + ";";
                            }
                            _loginCookies = _loginCookies.Substring(0, _loginCookies.Length - 1);
                            if (!string.IsNullOrEmpty(_loginCookies) && _loginCookies.Contains("sensorsdata2015jssdkcross") && _loginCookies.Contains("_eeos_traffic"))
                            {
                                flag = true;
                                break;
                            }
                            else
                            {
                                _loginCookies = "";
                            }
                        }
                        else
                        {
                            InfoHelper.WriteLine("未知异常，程序退出");
                            VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"未知异常，程序退出");
                            break;
                        }
                    }

                }
                catch (Exception ex)
                {
                    CloseFireFoxDriver(driver);
                    VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"获取cooki失败，{ex.Message}");
                    InfoHelper.WriteLine($"获取cooki失败，{ex.Message}");
                }
                finally
                {
                    driver.Close();
                    driver.Quit();
                    driver.Dispose();
                }
            }
            InfoHelper.WriteLine("完成登录...");
            VTX.FW.Helper.LogHelper.WriteInfo("RunAsync", $"完成登录...");
            return flag;

        }

        #region 异常 退出chromedriver
        [DllImport("user32.dll", EntryPoint = "FindWindow")]
        private extern static IntPtr FindWindow(string lpClassName, string lpWindowName);
        [DllImport("user32.dll", EntryPoint = "SendMessage")]
        public static extern int SendMessage(IntPtr hWnd, int Msg, int wParam, int lParam);
        public const int SW_HIDE = 0;
        public const int SW_SHOW = 5;
        [DllImport("user32.dll", EntryPoint = "ShowWindow")]
        public static extern int ShowWindow(IntPtr hwnd, int nCmdShow);

        /// <summary>
        /// 获取窗口句柄
        /// </summary>
        /// <returns></returns>
        public static IntPtr GetWindowHandle()
        {
            string name = (Environment.CurrentDirectory + "\\geckodriver.exe");
            IntPtr hwd = FindWindow(null, name);
            return hwd;
        }

        /// <summary>
        /// 关闭chromedriver窗口
        /// </summary>
        public static void CloseWindow()
        {
            try
            {
                IntPtr hwd = GetWindowHandle();
                SendMessage(hwd, 0x10, 0, 0);
            }
            catch
            {

            }
        }

        /// <summary>
        /// 退出chromedriver
        /// </summary>
        /// <param name="driver"></param>
        public static void CloseFireFoxDriver(IWebDriver driver)
        {
            try
            {
                driver.Quit();
                driver.Dispose();
            }
            catch
            {
            }
            CloseWindow();
        }
        #endregion 异常 退出chromedriver

        public static Task FireFoxBeginSliderLoginHandler(IWebDriver driver)
        {
            //等待滑块加载
            Thread.Sleep(5000);
            driver.SwitchTo().Frame(driver.FindElement(By.Id("tcaptcha_iframe")));

            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.display = 'none';");
            var bgPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBg"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.display = 'block';document.getElementById(\"slideBg\").style.opacity = 0;");
            var blockPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBlock"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBg\").style.opacity = 1;");
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            if (!Directory.Exists(dirpath))
            {
                Directory.CreateDirectory(dirpath);
            }
            var fileBgPath = $"{dirpath}\\{DateTime.Now.Ticks}.png";
            var fileBlockPath = $"{dirpath}\\{DateTime.Now.Ticks }__1.png";
            bgPng.SaveAsFile(fileBgPath, ScreenshotImageFormat.Png);
            blockPng.SaveAsFile(fileBlockPath, ScreenshotImageFormat.Png);
            var bgX = FireFoxGetBoundary(fileBgPath, fileBlockPath);

            InfoHelper.WriteLine($"读取背景缺口边界X坐标： {bgX}");
            VTX.FW.Helper.LogHelper.WriteInfo("BeginSliderLoginHandler", $"读取背景缺口边界X坐标： {bgX}");

            Actions action = new(driver);
            var sliderButton = driver.FindElement(By.Id("tcaptcha_drag_button"));
            if (sliderButton != null)
            {
                ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 1;");
                action.ClickAndHold(sliderButton).Build().Perform();
                #region 开始拟人移动
                var d1 = Math.Round(bgX * 0.8);
                var d2 = Math.Round(bgX * 0.1);
                var d3 = Math.Round(bgX * 0.1);
                action.MoveByOffset((int)d1, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d2, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d3, 1);
                action.MoveByOffset((bgX - (int)d1 - (int)d2 - (int)d3), 1);
                Thread.Sleep(2000);
                #endregion
                action.Release(sliderButton);
                action.Build().Perform();
                driver.SwitchTo().DefaultContent();
            }
            return Task.CompletedTask;
        }

        private static int FireFoxGetBoundary(string fileBgPath, string fileBlockPath)
        {
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            var bgImg = Cv2.ImRead(fileBgPath);
            var tpImg = Cv2.ImRead(fileBlockPath);

            var bgEdge = new Mat();
            Cv2.Canny(bgImg, bgEdge, 100, 200);

            var tpEdge = new Mat();
            Cv2.Canny(tpImg, edges: tpEdge, 100, 200);


            var bgPic = new Mat();
            Cv2.CvtColor(bgEdge, bgPic, ColorConversionCodes.GRAY2RGB);

            var tpPic = new Mat();
            Cv2.CvtColor(tpEdge, tpPic, ColorConversionCodes.GRAY2RGB);


            var res = new Mat();
            Cv2.MatchTemplate(bgPic, tpPic, res, TemplateMatchModes.CCoeffNormed);
            OpenCvSharp.Point minLoc = new OpenCvSharp.Point(), maxLoc = new OpenCvSharp.Point();
            Cv2.MinMaxLoc(res, out double minVal, out double maxVal, out minLoc, out maxLoc);

            var bt = new OpenCvSharp.Point(maxLoc.X + tpPic.Width, maxLoc.Y + tpPic.Height);
            Cv2.Rectangle(bgImg, maxLoc, bt, Scalar.Red, 2);
            string newImage = $"{dirpath}\\{DateTime.Now.Ticks}_NewBg.png";
            Cv2.ImWrite(newImage, bgImg);
            File.Delete(fileBgPath);
            File.Delete(fileBlockPath);
            File.Delete(newImage);
            return maxLoc.X - 20;
        }



        public static Task BeginSliderLoginHandler(ref IWebDriver driver)
        {
            //等待滑块加载
            Thread.Sleep(5000);
            driver.SwitchTo().Frame(driver.FindElement(By.Id("tcaptcha_iframe")));
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.display = none;");
            var bgPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBg"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 1;document.getElementById(\"slideBg\").style.opacity = 0;");
            var blockPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBlock"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBg\").style.opacity = 1;");
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            if (!Directory.Exists(dirpath))
            {
                Directory.CreateDirectory(dirpath);
            }
            var fileBgPath = $"{dirpath}\\{DateTime.Now.Ticks}.png";
            var fileBlockPath = $"{dirpath}\\{DateTime.Now.Ticks + 1}.png";
            bgPng.SaveAsFile(fileBgPath, ScreenshotImageFormat.Png);
            blockPng.SaveAsFile(fileBlockPath, ScreenshotImageFormat.Png);


            var bgX = GetBoundary(fileBgPath, fileBlockPath);
            InfoHelper.WriteLine($"读取背景缺口边界X坐标： {bgX}");
            VTX.FW.Helper.LogHelper.WriteInfo("BeginSliderLoginHandler", $"读取背景缺口边界X坐标： {bgX}");

            Actions action = new(driver);
            var sliderButton = driver.FindElement(By.Id("tcaptcha_drag_button"));
            if (sliderButton != null)
            {
                ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 1;");
                action.ClickAndHold(sliderButton).Build().Perform();
                #region 开始拟人移动
                var d1 = Math.Round(bgX * 0.8);
                var d2 = Math.Round(bgX * 0.1);
                var d3 = Math.Round(bgX * 0.1);
                action.MoveByOffset((int)d1, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d2, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d3, 1);
                action.MoveByOffset((bgX - (int)d1 - (int)d2 - (int)d3), 1);
                Thread.Sleep(2000);
                #endregion
                action.Release(sliderButton);
                action.Build().Perform();
                driver.SwitchTo().DefaultContent();
            }
            File.Delete(fileBgPath);
            File.Delete(fileBlockPath);
            return Task.CompletedTask;
        }

        private static int GetBoundary(string bg, string tp)
        {
            var bgImg = Cv2.ImRead(bg);
            var tpImg = Cv2.ImRead(tp);

            var bgEdge = new Mat();
            Cv2.Canny(bgImg, bgEdge, 100, 200);
            var tpEdge = new Mat();
            Cv2.Canny(tpImg, edges: tpEdge, 100, 200);


            var bgPic = new Mat();
            Cv2.CvtColor(bgEdge, bgPic, ColorConversionCodes.GRAY2RGB);
            var tpPic = new Mat();
            Cv2.CvtColor(tpEdge, tpPic, ColorConversionCodes.GRAY2RGB);

            var res = new Mat();
            Cv2.MatchTemplate(bgPic, tpPic, res, TemplateMatchModes.CCoeffNormed);
            OpenCvSharp.Point minLoc = new OpenCvSharp.Point(), maxLoc = new OpenCvSharp.Point();
            Cv2.MinMaxLoc(res, out double minVal, out double maxVal, out minLoc, out maxLoc);

            var bt = new OpenCvSharp.Point(maxLoc.X + tpPic.Width, maxLoc.Y + tpPic.Height);
            Cv2.Rectangle(bgImg, maxLoc, bt, Scalar.Red, 2);
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            Cv2.ImWrite($"{dirpath}\\{DateTime.Now.Ticks}.png", bgImg);

            return maxLoc.X - 20;
        }

        private static void HeartLine()
        {
            while (_openHeartTimer)
            {
                var handler = new HttpClientHandler
                {
                    AllowAutoRedirect = false,
                    UseCookies = true,
                    CookieContainer = CreateCookie(),
                    AutomaticDecompression = DecompressionMethods.GZip,
                    ClientCertificateOptions = ClientCertificateOption.Automatic
                };
                var http = new HttpClient(handler);
                http.GetAsync("https://console.eeo.cn/saas/school/index.html#/fullPage/Index?lang=zh-CN");
                //TODO:检查是否需要重新登录
                Thread.Sleep(60 * 1000);
            }
        }

        public static void StopHeartLine()
        {
            _openHeartTimer = false;
        }

        private static CookieContainer CreateCookie()
        {
            var uri = new Uri("https://console.eeo.cn");
            var cc = new CookieContainer();
            foreach (var str in _loginCookies.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }
    }
}
