﻿using EduSpider.Model.Entity;
using System;
using System.Collections.Generic;
using VTX.FW.Attr;

namespace EduSpider.Model.Extend
{
    /// <summary>
    /// 考试分数扩展
    /// </summary>
    public class RB_Exam_Score_Extend : RB_Exam_Score
    {

        /// <summary>
        /// 考试名称
        /// </summary>
        public string ExamName { get; set; }

        public List<ExamQScoreModel> ScoreList { get; set; }

        /// <summary>
        /// 考试导入时间
        /// </summary>
        public DateTime ExamCreateTime { get; set; }

        /// <summary>
        /// 考试ids
        /// </summary>
        public string ExamIds { get; set; }

        /// <summary>
        /// 1-8题得分
        /// </summary>
        public decimal PartScore { get; set; }

        /// <summary>
        /// 一试得分
        /// </summary>
        public decimal AScore { get; set; }

        /// <summary>
        /// 一试排名
        /// </summary>
        public int ARank { get; set; }

        /// <summary>
        /// 考试类型
        /// </summary>
        public int ExamType { get; set; }
    }

    /// <summary>
    /// 学生单项分数
    /// </summary>
    public class ExamQScoreModel
    {
        /// <summary>
        /// 题号
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 得分
        /// </summary>
        public decimal Score { get; set; }
        /// <summary>
        /// 平均得分
        /// </summary>
        public decimal AvgScore { get; set; }

        /// <summary>
        /// 难度
        /// </summary>
        public string Difficulty { get; set; }

        /// <summary>
        /// 知识点
        /// </summary>
        public string KnowledgePoint { get; set; }

        /// <summary>
        /// 题目分数
        /// </summary>
        public decimal QScore { get; set; }

        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 分组排序
        /// </summary>
        public int GroupNum { get; set; }

        /// <summary>
        /// 一试得分
        /// </summary>
        public decimal AScore { get; set; }

        /// <summary>
        /// 一试排名
        /// </summary>
        public decimal ARank { get; set; }
    }

    /// <summary>
    /// 1-8题得分
    /// </summary>
    public class ExamPartScoreModel { 
        /// <summary>
        /// 学生ID
        /// </summary>
        public int StuId { get; set; }
        /// <summary>
        /// 第几次考试
        /// </summary>
        public int Sort { get; set; }

        /// <summary>
        /// 考试名称 /知识点名称
        /// </summary>
        public string ExamName { get; set; }

        /// <summary>
        /// 个人得分/ 考试排名
        /// </summary>
        public decimal Score { get; set; }

        /// <summary>
        /// 平均得分
        /// </summary>
        public decimal AvgScore { get; set; }

        /// <summary>
        /// 分组名称
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// 分组次数
        /// </summary>
        public int GroupNum { get; set; }

        /// <summary>
        /// 总分
        /// </summary>
        public decimal TScore { get; set; }
    }

    /// <summary>
    /// 统计分析
    /// </summary>
    public class ExamStatModel { 
        /// <summary>
        /// 1-8题
        /// </summary>
        public List<ExamPartScoreModel> PartScoreList { get; set; }

        /// <summary>
        /// 分组排名
        /// </summary>
        public List<ExamPartScoreModel> GroupScoreList { get; set; }

        /// <summary>
        /// 总排名
        /// </summary>
        public List<ExamPartScoreModel> TRankScoreList { get; set; }

        /// <summary>
        /// 模块分析
        /// </summary>
        public List<ExamPartScoreModel> ModuleScoreList { get; set; }
    }
}
