﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EduSpider.Repository
{
    /// <summary>
    /// 账号仓储层
    /// </summary>
    public class AccountRepository : BaseRepository<rb_account_hk>, IAccountRepository
    {
        /// <summary>
        /// 批量新增账号
        /// </summary>
        /// <param name="accounts"></param>
        /// <returns></returns>
        public bool BatchSetAccount(List<rb_account_hk> accounts)
        {
            return base.BatchInsert(accounts, isReplace: true);
        }

        /// <summary>
        /// 获取账户列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<rb_account_hk_Extend> GetAccountList(rb_account_hk_Extend demodel)
        {
            string where = " 1=1 ";
            if (demodel.Id > 0)
            {
                where += $" and t.{nameof(rb_account_hk_Extend.Id)} ={demodel.Id}";
            }
            if (demodel.AccountType > 0)
            {
                where += $" and t.{nameof(rb_account_hk_Extend.AccountType)} ={(int)demodel.AccountType}";
            }
            if (demodel.AccountId > 0)
            {
                where += $" and t.{nameof(rb_account_hk_Extend.AccountId)} ={demodel.AccountId}";
            }
            if (demodel.Status >= 0)
            {
                where += $" and t.{nameof(rb_account_hk_Extend.Status)} ={(int)demodel.Status}";
            }
            if (!string.IsNullOrEmpty(demodel.Account))
            {
                where += $" and t.{nameof(rb_account_hk_Extend.Account)} ='{demodel.Account}'";
            }
            if (!string.IsNullOrEmpty(demodel.Password))
            {
                where += $" and t.{nameof(rb_account_hk_Extend.Password)} ='{demodel.Password}'";
            }
            if (!string.IsNullOrEmpty(demodel.Accounts))
            {
                where += $" and t.{nameof(rb_account_hk_Extend.Account)} in({demodel.Accounts})";
            }

            string sql = $@"
select * from(
SELECT a.UniqueId,a.Id,a.Account,a.`Password`,a.AccountType,a.AccountId,t.TeacherName AS AccountName,t.Logo as UserIcon,a.Status FROM rb_account_hk a 
INNER JOIN rb_teacher_hk t on a.Id =t.TeacherId and a.AccountType =1
UNION 
SELECT a.UniqueId,a.Id,a.Account,a.`Password`,a.AccountType,a.AccountId,s.StudentName AS AccountName,'' as UserIcon,a.Status FROM rb_account_hk a 
INNER JOIN rb_student_hk s on a.Id =s.StudId and a.AccountType =2
) t where {where}
";
            return Get<rb_account_hk_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取最大ID
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        public int GetMaxStuTeaId(int type)
        {
            string sql = $" select max(Id) from rb_account_hk where AccountType ={type}";
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }

        /// <summary>
        /// 获取教师信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<EmployeeInfo> GetEmployeeListRepository(EmployeeInfo query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* FROM
(
    SELECT A.School_Id,A.TeacherName AS EmployeeName,A.TeacherTel AS EmployeeTel 
    FROM rb_teacher AS A 
    UNION ALL 
    SELECT A.School_Id,A.MName AS EmployeeName,A.MTel AS EmployeeTel 
    FROM rb_manager AS A 
) AS A 
WHERE 1=1
");
            if (!string.IsNullOrEmpty(query.EmployeeName) || !string.IsNullOrEmpty(query.EmployeeTel))
            {
                builder.AppendFormat(" AND (A.EmployeeName='{0}' OR  A.EmployeeTel='{1}') ", query.EmployeeName.Trim(), query.EmployeeTel.Trim());
                return Get<EmployeeInfo>(builder.ToString()).ToList();
            }
            else
            {
                return new List<EmployeeInfo>();
            }
        }
    }
}
