﻿using System;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Utility
{
    /// <summary>
    /// Http请求帮助类
    /// </summary>
    public class SchoolHttpHelper
    {
        /// <summary>
        /// 创建HttpClient
        /// </summary>
        /// <param name="cookie"></param>
        /// <returns></returns>
        public static HttpClient GenerateHttp(string cookie)
        {
            var handler = new HttpClientHandler
            {
                AllowAutoRedirect = false,
                UseCookies = true,
                CookieContainer = CreateCookie(cookie),
                AutomaticDecompression = DecompressionMethods.GZip,
                ClientCertificateOptions = ClientCertificateOption.Automatic
            };
            
            var http = new HttpClient(handler);
            GenerateHttpHeader(ref http);
            return http;
        }


        /// <summary>
        /// 拼接Header参数
        /// </summary>
        /// <param name="http"></param>
        private static void GenerateHttpHeader(ref HttpClient http)
        {
            http.DefaultRequestHeaders.Add("Accept", "*/*");
            http.DefaultRequestHeaders.Add("Accept-Encoding", "gzip, deflate, br");
            http.DefaultRequestHeaders.Add("Accept-Language", "zh-CN,zh;q=0.9");
            http.DefaultRequestHeaders.Add("Cache-Control", "no-cache");
            http.DefaultRequestHeaders.Add("Origin", "https://tms11.xiaogj.com");
            http.DefaultRequestHeaders.Add("Pragma", "no-cache");
            http.DefaultRequestHeaders.Add("Referer", "https://tms11.xiaogj.com/index.html");
             
            http.DefaultRequestHeaders.Add("sec-ch-ua", "\" Not; A Brand\";v=\"99\", \"Google Chrome\";v=\"97\", \"Chromium\";v=\"97\"");
            http.DefaultRequestHeaders.Add("sec-ch-ua-mobile", "?0");
            http.DefaultRequestHeaders.Add("sec-ch-ua-platform", "\"Windows\"");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Dest", "empty");
            http.DefaultRequestHeaders.Add("Sec-Fetch-Mode", "cors");

            http.DefaultRequestHeaders.Add("Sec-Fetch-Site", "same-origin");
            http.DefaultRequestHeaders.Add("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36");
            
            http.DefaultRequestHeaders.Add("pragma", "no-cache");
        }

        /// <summary>
        /// 拼接Cookie
        /// </summary>
        /// <param name="cookieStr"></param>
        /// <returns></returns>
        private static CookieContainer CreateCookie(string cookieStr)
        {
            var uri = new Uri("https://tms11.xiaogj.com");
            var cc = new CookieContainer();
            foreach (var str in cookieStr.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }

        /// <summary>
        /// Post提交数据
        /// </summary>
        /// <param name="url">url地址</param>
        /// <param name="body">参数</param>
        /// <param name="contenttype">参数</param>
        /// <returns></returns>
        public static string HttpPost(string url, string body, string contenttype = "", string cookie = "")
        {
            try
            {
                Encoding encoding = Encoding.UTF8;
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
                request.Method = "POST";
                request.Accept = "application/json, text/javascript, */*"; //"text/html, application/xhtml+xml, */*";
                request.ContentType = "application/json; charset=utf-8";
                if (contenttype != "")
                {
                    request.ContentType = contenttype;
                }
                if (!string.IsNullOrEmpty(cookie))
                {
                    request.Headers.Add("cookie", cookie);
                }
                byte[] buffer = encoding.GetBytes(body);
                request.ContentLength = buffer.Length;
                request.GetRequestStream().Write(buffer, 0, buffer.Length);
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                using StreamReader reader = new StreamReader(response.GetResponseStream(), encoding);
                return reader.ReadToEnd();
            }
            catch (WebException ex)
            {
                var res = (HttpWebResponse)ex.Response;
                StringBuilder sb = new StringBuilder();
                StreamReader sr = new StreamReader(res.GetResponseStream(), Encoding.UTF8);
                sb.Append(sr.ReadToEnd());
                throw new Exception(sb.ToString());
            }
        }

        /// <summary>
        /// 执行HTTP GET请求。
        /// </summary>
        /// <param name="url">请求地址</param>
        /// <returns>HTTP响应</returns>
        public static string HttpGet(string url)
        {
            string result = "";
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            req.Method = "GET";
            req.ContentType = "application/json";
            HttpWebResponse rsp = (HttpWebResponse)req.GetResponse();

            Encoding encoding = Encoding.UTF8;
            if (!string.IsNullOrWhiteSpace(rsp.CharacterSet))
            {
                encoding = Encoding.GetEncoding(rsp.CharacterSet);
            }
            System.IO.Stream stream = null;
            StreamReader reader = null;
            try
            {
                // 以字符流的方式读取HTTP响应
                stream = rsp.GetResponseStream();
                reader = new StreamReader(stream, encoding);
                result = reader.ReadToEnd();
            }
            catch (Exception ex)
            {
                LogHelper.WriteError("", string.Format("HttpGet:url=={0}", url), ex);
                result = "";
            }
            finally
            {
                // 释放资源
                if (reader != null) reader.Close();
                if (stream != null) stream.Close();
                if (rsp != null) rsp.Close();
            }
            return result;
        }
    }
}