﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility.Enum;
using EduSpider.Utility.Plugin;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Web;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 课程关联
    /// </summary>
    public class CourseManager
    {
        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static async void RunCourse(string cookie)
        {
            int perpage = 200;
            var pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "page={0}&perpage={1}";
            string paramStr = string.Format(queryStr, pageCount, perpage);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseRepository courseRepository = new CourseRepository();
            int totalCount = 0;
            try
            {
                string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList";
                var response = await request.PostAsync(url, content);
                var result = response.Content.ReadAsStringAsync().Result;
                if (!string.IsNullOrWhiteSpace(result))
                {
                    JObject rootObj = JObject.Parse(result);
                    if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                    {
                        JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                        var totalNum = dataObj.GetInt("totalCourseNum");
                        var tempList = ParseJson(dataObj.GetString("courseList"));
                        if (tempList != null && tempList.Count > 0)
                        {
                            courseRepository.BatchSetCourseRepository(tempList);
                            totalCount += tempList.Count;
                            InfoHelper.WriteLine(string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                            VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                            foreach (var item in tempList)
                            {
                                RunCourseStudent(cookie, item.CourseId);
                                RunCourseTeacher(cookie, item.CourseId);
                                RunCourseInfo(cookie, item.CourseId);
                                GetCourseLessionList(cookie, item);
                            }
                        }
                        if (totalNum % perpage == 0)
                        {
                            pageCount = totalNum / perpage;
                        }
                        else
                        {
                            pageCount = totalNum / perpage + 1;
                        }
                        if (totalNum > perpage)
                        {
                            for (var i = 2; i <= pageCount; i++)
                            {
                                Thread.Sleep(1000 * 2);
                                paramStr = string.Format(queryStr, i, perpage);
                                var sub_content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                                try
                                {
                                    var sub_response = await request.PostAsync(url, sub_content);
                                    var sub_result = sub_response.Content.ReadAsStringAsync().Result;
                                    if (!string.IsNullOrWhiteSpace(sub_result))
                                    {
                                        JObject sub_rootObj = JObject.Parse(sub_result);
                                        if (!string.IsNullOrWhiteSpace(sub_rootObj.GetString("data")))
                                        {
                                            JObject sub_dataObj = JObject.Parse(sub_rootObj.GetString("data"));
                                            var subtempList = ParseJson(sub_dataObj.GetString("courseList"));
                                            if (subtempList != null && subtempList.Count > 0)
                                            {
                                                courseRepository.BatchSetCourseRepository(subtempList);
                                                totalCount += subtempList.Count;
                                                foreach (var sItem in subtempList)
                                                {
                                                    RunCourseStudent(cookie, sItem.CourseId);
                                                    RunCourseTeacher(cookie, sItem.CourseId);
                                                    RunCourseInfo(cookie, sItem.CourseId);
                                                    GetCourseLessionList(cookie, sItem);
                                                }
                                                InfoHelper.WriteLine(string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                                VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                            }
                                        }
                                    }
                                }
                                catch (Exception ex2)
                                {
                                    VTX.FW.Helper.LogHelper.WriteError("CourseManager_RunCourse2", ex: ex2);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("CourseManager_RunCourse", ex: ex);
            }
        }

        /// <summary>
        /// JSON字符串转课程列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<rb_course_hk> ParseJson(string data)
        {
            List<rb_course_hk> list = new();
            JArray courseArray = JArray.Parse(data);
            if (courseArray != null && courseArray.Count > 0)
            {
                foreach (var jItem in courseArray)
                {
                    JObject courseObj = JObject.Parse(jItem.ToString());
                    var expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime"));
                    if (ConvertHelper.FormatTime(expiryTime) == "1970-01-01 08:00:00")
                    {
                        expiryTime = new DateTime(0001, 01, 01);
                    }
                    list.Add(new rb_course_hk()
                    {
                        CourseId = courseObj.GetInt("courseId"),
                        CourseName = courseObj.GetString("courseName"),
                        BeginTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                        CompleteNum = courseObj.GetInt("completeNum"),
                        TotalClassNum = courseObj.GetInt("totalClassNum"),
                        ExpiryTime = expiryTime,
                        LiveNum = courseObj.GetInt("liveNum"),
                        RecordNum = 0,
                        OpenNum = courseObj.GetInt("openNum"),
                        StudentNum = courseObj.GetInt("studentNum"),
                        AuditNum = courseObj.GetInt("auditNum"),
                        TeacherNum = courseObj.GetInt("teacherNum"),
                        CourseStatus = courseObj.GetInt("courseStatus"),
                        WebCast = courseObj.GetString("webCast"),
                        TeacherId = courseObj.GetInt("teacherId"),
                        TeacherAccount = courseObj.GetString("teacherAccount"),
                        TeacherUid = courseObj.GetInt("teacherUid"),
                        TeacherName = courseObj.GetString("teacherName"),
                        TeacherLogo = courseObj.GetString("teacherLogo"),
                        CourseType = courseObj.GetInt("courseType"),
                    });
                }
            }
            return list;
        }

        /// <summary>
        /// 获取课程关联学员列表
        /// </summary>

        public static async void RunCourseStudent(string cookie, int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            if (courseId == 211441479)
            {
                string str = "";
            }
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseStudentRepository courseStudentRepository = new CourseStudentRepository();

            InfoHelper.WriteLine(string.Format("开始获取{0}课程学员数据", courseId));

            string url = "https://console.eeo.cn/saasajax/student.ajax.php?action=getCourseStudentList";
            List<RB_Course_Student> list = new();
            List<RB_Course_Student> deleteList = new List<RB_Course_Student>();
            try
            {
                var response = await request.PostAsync(url, content);
                var sutResult = response.Content.ReadAsStringAsync().Result;
                if (!string.IsNullOrWhiteSpace(sutResult))
                {
                    JObject stuRootObj = JObject.Parse(sutResult);
                    if (!string.IsNullOrWhiteSpace(stuRootObj.GetString("data")))
                    {
                        JArray courseStudentArray = JArray.Parse(stuRootObj.GetString("data"));
                        if (courseStudentArray != null && courseStudentArray.Count > 0)
                        {
                            foreach (var jItem in courseStudentArray)
                            {
                                JObject courseStuObj = JObject.Parse(jItem.ToString());
                                string deleteCourseStudentReplay = courseStuObj.GetString("deleteCourseStudentReplay");
                                if (deleteCourseStudentReplay != "0")
                                {
                                    list.Add(new RB_Course_Student()
                                    {
                                        id = courseStuObj.GetInt("id"),
                                        uid = courseStuObj.GetInt("uid"),
                                        name = courseStuObj.GetString("name"),
                                        account = courseStuObj.GetString("account"),
                                        logo = courseStuObj.GetString("logo"),
                                        courseId = courseId
                                    });
                                }
                                else
                                {
                                    deleteList.Add(new RB_Course_Student()
                                    {
                                        id = courseStuObj.GetInt("id"),
                                        uid = courseStuObj.GetInt("uid"),
                                        name = courseStuObj.GetString("name"),
                                        account = courseStuObj.GetString("account"),
                                        logo = courseStuObj.GetString("logo"),
                                        courseId = courseId
                                    });
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("CourseManager_RunCourseStudent", ex: ex);
            }
            if (list != null && list.Count > 0)
            {
                courseStudentRepository.BatchSetCourseStudentRepository(list);
            }
            if (deleteList != null && deleteList.Count > 0)
            {
                courseStudentRepository.BatchDeleteCourseStudentRepository(deleteList);
            }
        }

        /// <summary>
        /// 获取课程关联老师列表
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="courseId"></param>
        public static async void RunCourseTeacher(string cookie, int courseId)
        {
            List<RB_Course_Teacher> list = new();
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseTeacherRepository courseTeacherRepository = new CourseTeacherRepository();
            InfoHelper.WriteLine(string.Format("开始获取{0}课程老师数据", courseId));

            string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseTeacherList";
            try
            {
                var response = await request.PostAsync(url, content);
                var teacherResult = response.Content.ReadAsStringAsync().Result;
                if (!string.IsNullOrWhiteSpace(teacherResult))
                {
                    JObject teacherRootObj = JObject.Parse(teacherResult);
                    if (!string.IsNullOrWhiteSpace(teacherRootObj.GetString("data")))
                    {
                        JObject teacherObj = JObject.Parse(teacherRootObj.GetString("data"));
                        if (!string.IsNullOrWhiteSpace(teacherObj.GetString("teacherList")))
                        {
                            JArray courseTeacherArray = JArray.Parse(teacherObj.GetString("teacherList"));
                            if (courseTeacherArray != null && courseTeacherArray.Count > 0)
                            {
                                foreach (var jItem in courseTeacherArray)
                                {
                                    JObject courseTeacherObj = JObject.Parse(jItem.ToString());
                                    JObject infoObj = JObject.Parse(courseTeacherObj.GetString("teacherInfo"));
                                    list.Add(new RB_Course_Teacher()
                                    {
                                        id = infoObj.GetInt("id"),
                                        uid = infoObj.GetInt("uid"),
                                        phone = infoObj.GetString("phone"),
                                        logo = infoObj.GetString("logo"),
                                        name = infoObj.GetString("name"),
                                        courseId = courseId,
                                        courseTeacherId = courseTeacherObj.GetInt("courseTeacherId")
                                    });
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("CourseManager_RunCourseTeacher", ex: ex);
            }
            if (list != null && list.Count > 0)
            {
                courseTeacherRepository.BatchSetCourseTeacherRepository(list);
            }
        }

        /// <summary>
        /// 查询课程信息
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="courseId"></param>
        public static async void RunCourseInfo(string cookie, int courseId)
        {
            List<rb_course_hk> list = new();
            List<RB_Course_Teacher> teacherList = new();
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseRepository courseRepository = new CourseRepository();
            ICourseTeacherRepository courseTeacherRepository = new CourseTeacherRepository();
            InfoHelper.WriteLine(string.Format("开始获取{0}课程详情数据", courseId));

            string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseInfo";
            try
            {
                var response = await request.PostAsync(url, content);
                var courseInfoResult = response.Content.ReadAsStringAsync().Result;

                if (!string.IsNullOrWhiteSpace(courseInfoResult))
                {
                    JObject courseRootObj = JObject.Parse(courseInfoResult);
                    if (!string.IsNullOrWhiteSpace(courseRootObj.GetString("data")))
                    {
                        JObject courseObj = JObject.Parse(courseRootObj.GetString("data"));
                        var expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime"));
                        if (ConvertHelper.FormatTime(expiryTime) == "1970-01-01 08:00:00")
                        {
                            expiryTime = new DateTime(0001, 01, 01);
                        }
                        var courseModel = new rb_course_hk()
                        {
                            CourseId = courseObj.GetInt("courseId"),
                            CourseName = courseObj.GetString("courseName"),
                            BeginTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                            CompleteNum = courseObj.GetInt("completeNum"),
                            TotalClassNum = courseObj.GetInt("totalClassNum"),
                            ExpiryTime = expiryTime,
                            LiveNum = courseObj.GetInt("liveNum"),
                            RecordNum = 0,
                            OpenNum = courseObj.GetInt("openNum"),
                            StudentNum = courseObj.GetInt("studentNum"),
                            AuditNum = courseObj.GetInt("auditNum"),
                            TeacherNum = courseObj.GetInt("teacherNum"),
                            CourseStatus = courseObj.GetInt("courseStatus"),
                            WebCast = courseObj.GetString("webCastUrl"),
                            TeacherId = courseObj.GetInt("teacherId"),
                            TeacherAccount = courseObj.GetString("teacherAccount"),
                            TeacherUid = courseObj.GetInt("teacherUid"),
                            TeacherName = courseObj.GetString("teacherName"),
                            TeacherLogo = courseObj.GetString("teacherLogo"),
                            CourseType = courseObj.GetInt("courseType"),
                            AddTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("addTime")),
                            CourseWare = courseObj.GetString("courseWare"),
                        };

                        string tempCoverImg = courseObj.GetString("coverImg");
                        string coverImg = "";
                        if (!string.IsNullOrWhiteSpace(tempCoverImg))
                        {
                            coverImg = "https://console.eeo.cn/upload/images/" + tempCoverImg;
                        }
                        courseModel.CoverImg = coverImg;
                        list.Add(courseModel);
                        if (courseModel.TeacherUid > 0)
                        {
                            var cTeacherModel = courseTeacherRepository.GetTeacherCourseListRepository(new Model.Query.CourseQuery()
                            {
                                CourseId = courseModel.CourseId,
                                TeacherIds = courseModel.TeacherUid.ToString()
                            }).FirstOrDefault();
                            int newId = Convert.ToInt32(DateTime.Now.ToString("yyyyMMdd"));

                            var courseTeacher = new RB_Course_Teacher()
                            {
                                id = cTeacherModel?.id ?? newId,
                                uid = Convert.ToInt32(courseModel.TeacherUid),
                                phone = courseModel.TeacherAccount,
                                logo = courseModel.TeacherLogo,
                                name = courseModel.TeacherName,
                                courseId = courseId,
                                courseTeacherId = courseModel.TeacherId
                            };
                            teacherList.Add(courseTeacher);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("CourseManager_RunCourseInfo", ex: ex);
            }
            if (list != null && list.Count > 0)
            {
                courseRepository.BatchSetCourseOtherRepository(list);
            }
            if (teacherList != null && teacherList.Count > 0)
            {
                courseTeacherRepository.BatchSetCourseTeacherRepository(teacherList);
            }
        }

        /// <summary>
        /// 获取课程章节
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="cItem"></param>
        public static async void GetCourseLessionList(string cookie, rb_course_hk cItem)
        {
            InfoHelper.WriteLine(string.Format("开始获取{0}课程章节数据", cItem.CourseId));
            ICourseRepository courseRepository = new CourseRepository();
            List<rb_course_hk> list = new();
            Uri uri = new Uri(cItem.WebCast);// 在这里用的Uri这个，如果直接打印出来uri，会将source后面的编码解密出来："博汇数码"
            string queryString = uri.Query;
            NameValueCollection col = HttpUtility.ParseQueryString(uri.Query);
            string searchKey = col["courseKey"];

            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = $"courseKey={searchKey}";
            var content = new StringContent(queryStr, Encoding.UTF8, "application/x-www-form-urlencoded");
            var lessonKeyList = new List<string>();
            int lessonVodCount = 0;
            string url = "https://live.eeo.cn/saasajax/webcast.ajax.php?action=getLessonList";
            try
            {
                var response = request.PostAsync(url, content).Result;
                var result = response.Content.ReadAsStringAsync().Result;
                if (!string.IsNullOrWhiteSpace(result))
                {
                    var rootObj = JObject.Parse(result);
                    if (rootObj.ContainsKey("data"))
                    {
                        JArray dataArray = JArray.Parse(rootObj["data"].ToString());
                        if (dataArray != null && dataArray.Count > 0)
                        {
                            foreach (var sItem in dataArray)
                            {
                                JObject sObj = JObject.Parse(JsonHelper.Serialize(sItem));
                                lessonKeyList.Add(sObj.GetString("lessonKey"));
                                int lessonStatus = sObj.GetInt("lessonStatus");
                                if (lessonStatus == 1)
                                {
                                    lessonVodCount += sObj.GetInt("lessonVodCount");
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                VTX.FW.Helper.LogHelper.WriteError("CourseManager_GetCourseLessionList", ex: ex);
            }
            if (lessonVodCount > 0)
            {
                var resultList = new List<string>();
                //var request2 = Utility.HttpHelper.GenerateHttp(cookie);
                //string url2 = "https://live.eeo.cn/saasajax/webcast.ajax.php?action=getLessonWebcastData";
                //foreach (var item in lessonKeyList)
                //{
                //    string queryStr2 = $"lessonKey={item}&cookie=e52r4pMWa&account=18140082327&setCookie=83004edb2abaced372ea32ba905f22fb";
                //    var content2 = new StringContent(queryStr2, Encoding.UTF8, "application/x-www-form-urlencoded");
                //    var response2 = request2.PostAsync(url2, content2).Result;
                //    var result2 = response2.Content.ReadAsStringAsync().Result;

                //    if (!string.IsNullOrWhiteSpace(result2))
                //    {
                //        var rootObj = JObject.Parse(result2);
                //        if (rootObj.ContainsKey("data"))
                //        {
                //            var dataObj = JObject.Parse(rootObj["data"].ToString());
                //            if (dataObj.ContainsKey("lessonData"))
                //            {
                //                var array = dataObj["lessonData"].ToString().Contains("fileList") ? dataObj["lessonData"]["fileList"] as JArray : new JArray();
                //                foreach (JObject sitem in array)
                //                {
                //                    var subArray = sitem["Playset"] as JArray;
                //                    foreach (JObject subItem in subArray)
                //                    {
                //                        var videoUrl = subItem.GetString("Url");
                //                        if (!string.IsNullOrEmpty(videoUrl))
                //                        {
                //                            resultList.Add(videoUrl);
                //                        }
                //                    }
                //                }
                //            }

                //        }
                //    } 
                //}
                if (resultList != null && resultList.Count > 0)
                {

                }
                rb_course_hk model = new rb_course_hk()
                {
                    CourseId = cItem.CourseId,
                    RecordNum = lessonVodCount
                };
                list.Add(model);
            }
            if (list != null && list.Count > 0)
            {
                courseRepository.BatchSetCourseRecordNumRepository(list);
            }
        }
    }
}
