﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 学生作业
    /// </summary>
    public class HomeWorkManager
    {
        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        public async void RunHomeWork(string cookie)
        {
            int perpage = 20;
            var pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "page={0}&perpage={1}";
            string paramStr = string.Format(queryStr, pageCount, perpage);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            IHomeWorkRepository homeWorkRepository = new HomeWorkRepository();
            int totalCount = 0;
            Console.WriteLine(string.Format("开始第{0}次获取家庭作业", pageCount));
            string url = "https://console.eeo.cn/saasajax/homework.ajax.php?action=getHomeworkList";
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("total");
                    var tempList = ParseJson(dataObj.GetString("list"));
                    if (tempList != null && tempList.Count > 0)
                    {
                        homeWorkRepository.BatchSetHomeWorkRepository(tempList);
                        totalCount += tempList.Count;
                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                        foreach (var item in tempList)
                        {
                            //TODO

                        }
                    }
                    if (totalNum % perpage == 0)
                    {
                        pageCount = totalNum / perpage;
                    }
                    else
                    {
                        pageCount = totalNum / perpage + 1;
                    }
                    if (totalNum > perpage)
                    {
                        for (var i = 2; i <= pageCount; i++)
                        {
                            Thread.Sleep(1000 * 2);
                            Console.WriteLine(string.Format("第{0}/{1}次获取课程数据", i, pageCount));
                            paramStr = string.Format(queryStr, i, perpage);
                            var sub_content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                            var sub_response = await request.PostAsync(url, sub_content);

                            var sub_result = sub_response.Content.ReadAsStringAsync().Result;
                            if (!string.IsNullOrWhiteSpace(sub_result))
                            {
                                JObject sub_rootObj = JObject.Parse(sub_result);
                                if (!string.IsNullOrWhiteSpace(sub_rootObj.GetString("data")))
                                {
                                    JObject sub_dataObj = JObject.Parse(sub_rootObj.GetString("data"));
                                    var subtempList = ParseJson(sub_dataObj.GetString("list"));
                                    if (subtempList != null && subtempList.Count > 0)
                                    {
                                        homeWorkRepository.BatchSetHomeWorkRepository(subtempList);
                                        totalCount += subtempList.Count;
                                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                        foreach (var sItem in subtempList)
                                        {
                                            //TODO
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        }

        /// <summary>
        /// JSON字符串转课程列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<RB_HomeWork> ParseJson(string data)
        {
            List<RB_HomeWork> list = new List<RB_HomeWork>();
            if (!string.IsNullOrWhiteSpace(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var jItem in courseArray)
                    {
                        JObject homeObj = JObject.Parse(jItem.ToString());
                        list.Add(new RB_HomeWork()
                        {
                            homework_id = homeObj.GetInt("homework_id"),
                            homework_title = homeObj.GetString("homework_title"),
                            homework_share_key = homeObj.GetString("homework_share_key"),
                            course_id = homeObj.GetInt("course_id"),
                            course_name = homeObj.GetString("course_name"),
                            start_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("start_time")),
                            end_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("end_time")),
                            status = homeObj.GetInt("status"),
                            is_del = homeObj.GetInt("is_del"),
                            is_open = homeObj.GetInt("is_open"),
                            open_type = homeObj.GetInt("open_type"),
                            is_revise = homeObj.GetInt("is_revise"),
                            num = homeObj.GetInt("num"),
                            cream_num = homeObj.GetInt("cream_num"),
                            revised_num = homeObj.GetInt("revised_num"),
                            rnum = homeObj.GetInt("rnum"),
                            cnum = homeObj.GetInt("cnum"),
                            school_uid = homeObj.GetInt("school_uid"),
                            score_type = homeObj.GetInt("score_type"),
                            score_value = homeObj.GetDecimal("score_value"),
                            teacher_account = homeObj.GetString("teacher_account"),
                            teacher_name = homeObj.GetString("teacher_name"),
                            teacher_uid = homeObj.GetInt("teacher_uid"),
                            th_cancel = homeObj.GetString("th_cancel"),
                            add_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("add_time")),
                            update_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("update_time")),
                        });
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取学生提交作业数据
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="homework_id"></param>
        public static void RunStuHomeWork(string cookie, int homework_id)
        { 
        
        }
    }
}
