﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Config;

namespace EduSpider.IServices
{
    /// <summary>
    /// 课程服务层接口
    /// </summary>
    public interface ICourseService : IDependency
    {
        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetStuCourseList(CourseQuery query);


        /// <summary>
        /// 获取学员考试和家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetStuWorkAndExamList(CourseQuery query);

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseList(CourseQuery query);

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetCourseHomeWork(CourseQuery query);

        /// <summary>
        /// 获取作业详情
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public object GetHomeWorkDetails(CourseQuery query);

        /// <summary>
        /// 新增修改课程评价配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseComment(RB_Course_Comment_Extend model);

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Comment_Extend> GetCourseCommentList(CourseQuery query);


        /// <summary>
        /// 根据评价编号删除课程评价配置
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteCourseComment(string Ids);

        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <param name="DetailIds"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentDetail(string DetailIds);

        /// <summary>
        /// 新增修改学员评价
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuComment(RB_Stu_Comment model);

        /// <summary>
        /// 批量新增学员评价
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool BatchSetStuComment(List<RB_Stu_Comment> list);

        /// <summary>
        /// 获取学员评价列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment_Extend> GetStuCommentList(CourseQuery query);

        /// <summary>
        /// 修改学员评论状态
        /// </summary>
        /// <param name="ShowType"></param>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool SetStuCommentShowType(int ShowType, string Ids);

        /// <summary>
        /// 根据课程评论次数修改可见等级
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <param name="Times">次数</param>
        /// <param name="ShowType">可见性</param>
        /// <returns></returns>
        public bool SetStuCommentShowTypeByTimes(int CourseId, int Times, int ShouType);

        /// <summary>
        /// 根据编号删除学员评论
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool RemoveStuComment(string Ids);

        /// <summary>
        /// 获取系统生成评论次数 
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_Comment> GetCourseCommentTimesList(CourseQuery query);

        /// <summary>
        /// 获取系统评价配置
        /// </summary>
        /// <returns></returns>
        public List<RB_Comment> GetSysComment();

        /// <summary>
        /// 创建课程作业评论
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <returns></returns>
        public void CreateHomeWorkComment(int CourseId);
    }
}
