﻿using EduSpider.Model.Entity;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 评语仓储层接口
    /// </summary>
    public interface ICommentRepository : IDBRepository<RB_Comment>, IDependency
    {
        /// <summary>
        /// 根据查询条件获取评语
        /// </summary>
        /// <param name="Score"></param>
        /// <returns></returns>
        public RB_Comment GetComment(decimal Score);

        /// <summary>
        /// 获取系统配置评价列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Comment> GetCommentListRepository();
    }
}
