﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EduSpider.Repository
{
    /// <summary>
    /// 学生作业仓储层实现
    /// </summary>
    public class StuHomeWorkRepository : BaseRepository<RB_Stu_HomeWork>, IStuHomeWorkRepository
    {
        /// <summary>
        /// 评语配置仓储层对象
        /// </summary>
        private readonly CommentRepository commentRepository = new();

        /// <summary>
        /// 学员评论仓储层对象
        /// </summary>
        private readonly StuCommentRepository stuCommentRepository = new();

        /// <summary>
        /// 课程评价配置仓储对象
        /// </summary>
        private readonly CourseCommentRepository courseCommentRepository = new();

        /// <summary>
        /// 批量添加学生家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetStuHomeWorkRepository(List<RB_Stu_HomeWork> homeWorks)
        {
            bool flag;
            flag = base.BatchInsert(homeWorks, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_HomeWork_Extend> GetStuHomeWorkDetailsListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,B.homework_title,B.score_value,C.courseName
FROM RB_Stu_HomeWork AS A LEFT JOIN rb_homework AS B ON A.homework_id=B.homework_id
     LEFT JOIN rb_course AS C ON A.course_id=C.courseId
WHERE 1=1
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Stu_HomeWork_Extend.course_id), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.QCourseIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.course_id), query.QCourseIds);
                }
                if (!string.IsNullOrEmpty(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.student_uid), query.StuIds);
                }
                if (query.HomeWorkId > 0)
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Stu_HomeWork_Extend.homework_id), query.HomeWorkId);
                }
            }
            var dataList = Get<RB_Stu_HomeWork_Extend>(builder.ToString()).ToList();
            return dataList;
        }

        /// <summary>
        /// 创建课程作业评论
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <returns></returns>
        public List<ExamWorkResult> CreateHomeWorkCommentRepository(int CourseId)
        {
            List<ExamWorkResult> list = new();
            var dataList = GetStuHomeWorkDetailsListRepository(new CourseQuery() { CourseId = CourseId });

            var courseList = dataList.GroupBy(qitem => new { qitem.course_id }).Select(qitem=>new {qitem.Key.course_id });
            if (courseList != null && courseList.Count() > 0)
            {
                foreach (var cItem in courseList)
                {
                    var stuList = dataList.Where(qitem => qitem.course_id == cItem.course_id).GroupBy(qitem => new { qitem.student_uid }).Select(qitem => new{ qitem.Key.student_uid});
                    //课程配置评论列表
                    var courseCommentModel = courseCommentRepository.GetCourseCommentListRepository(new CourseQuery() { QCourseIds = cItem.course_id.ToString() }).FirstOrDefault();
                   
                    foreach (var sItem in stuList)
                    {
                        List<ExamWorkResult> homeWorkList = new();
                        //学员评论列表
                        var commentList = stuCommentRepository.GetStuCommentListRepository(new CourseQuery() { CourseId = cItem.course_id, StuIds = sItem.student_uid.ToString() });
                        var tempDataList = dataList.Where(qitem => qitem.course_id == cItem.course_id && qitem.student_uid == sItem.student_uid).ToList();
                        if (tempDataList != null && tempDataList.Count > 0)
                        {
                            int RowNum = 1;
                            foreach (var item in tempDataList)
                            {
                                homeWorkList.Add(new ExamWorkResult()
                                {
                                    RowNum = RowNum,
                                    CreateTime = item.add_time,
                                    ResultType = 1,
                                    Title = item.Homework_title,
                                    Score = item.score,
                                    Score_p = item.score_p,
                                    ScoreType = item.score_type,
                                    Score_Value = item.Score_value,
                                    HomeWorkStatus = item.status,
                                    ThName = item.th_name,
                                    Stu_HomeWork_Id = item.stu_homework_id,
                                });
                                RowNum++;
                            }
                        }
                    
                        string info;
                        if (homeWorkList != null && homeWorkList.Count > 0)
                        {
                            //第一次评价
                            if (homeWorkList.Count >= 5)
                            {
                                var firstList = homeWorkList.Where(qitem => qitem.RowNum <= 5).ToList();
                                var firstSubmitCount = firstList.Where(qitem => qitem.HomeWorkStatus == 0).Count();
                                //第一阶段有提交作业情况(至少一次)
                                if (firstList.Count!= firstSubmitCount)
                                {
                                    var firstScore = firstList.Average(qitem => qitem.Score_p) * 100;
                                    string title = firstList.LastOrDefault().ThName + "老师的评语";
                                    info = GetCommentInfo(courseCommentModel, firstScore);
                                    var First_Stu_HomeWork_Id = firstList.LastOrDefault().Stu_HomeWork_Id;
                                    var tempModel = GetSystemCreateComment(commentList, cItem.course_id, First_Stu_HomeWork_Id);
                                    var firstNum = CreateRandomNum();
                                    var firstStartTime = firstList.LastOrDefault().CreateTime;
                                    var secondModel = homeWorkList.Where(qitem => qitem.RowNum == 6).FirstOrDefault();
                                    if (secondModel != null)
                                    {
                                        double seconds = (secondModel.CreateTime - firstStartTime).TotalSeconds;
                                        Random rnd = new();
                                        var newSeconds = rnd.Next(0, Convert.ToInt32(seconds));
                                        firstStartTime = firstStartTime.AddSeconds(newSeconds);
                                    }
                                    else
                                    {
                                        firstStartTime = firstStartTime.AddMinutes(firstNum);
                                    }
                                    
                                    if (tempModel == null || (tempModel != null && tempModel.Id <= 0))
                                    {
                                        
                                        //新增系统生成评价
                                        stuCommentRepository.SetStuCommentRepository(new RB_Stu_Comment()
                                        {
                                            Id = 0,
                                            HomeWorkId = First_Stu_HomeWork_Id,
                                            StuUid = Convert.ToInt32(sItem.student_uid),
                                            CourseId = cItem.course_id,
                                            Times = 1,
                                            Info = info,
                                            CreateType = 1,
                                            CreateByName = firstList.LastOrDefault().ThName,
                                            CreateTime = firstStartTime,
                                            ShowType = 3,
                                        });
                                    }
                                }
                            }
                            //第二次评价
                            if (homeWorkList.Count >= 9)
                            {
                                var secondList = homeWorkList.Where(qitem => qitem.RowNum > 5 && qitem.RowNum <= 9).ToList();
                                var secondSubmitCount = secondList.Where(qitem => qitem.HomeWorkStatus == 0).Count();
                                //第二阶段有提交作业情况(至少一次)
                                if (secondList.Count()!= secondSubmitCount)
                                {
                                    var secondScore = secondList.Average(qitem => qitem.Score_p) * 100;
                                    info = GetCommentInfo(courseCommentModel, secondScore);
                                    var Second_Stu_HomeWork_Id = secondList.LastOrDefault().Stu_HomeWork_Id;
                                    var secondModel = GetSystemCreateComment(commentList, cItem.course_id, Second_Stu_HomeWork_Id);
                                    var secondNum = CreateRandomNum();
                                    var secondTime = secondList.LastOrDefault().CreateTime;
                                    var thirdModel = homeWorkList.Where(qitem => qitem.RowNum == 10).FirstOrDefault();
                                    if (thirdModel != null)
                                    {
                                        double seconds = (thirdModel.CreateTime - secondTime).TotalSeconds;
                                        Random rnd = new();
                                        var newSeconds = rnd.Next(0, Convert.ToInt32(seconds));
                                        secondTime = secondTime.AddSeconds(newSeconds);
                                    }
                                    else
                                    {
                                        secondTime = secondTime.AddMinutes(secondNum);
                                    }

                                    if (secondModel == null || (secondModel != null && secondModel.Id <= 0))
                                    {
                                        stuCommentRepository.SetStuCommentRepository(new RB_Stu_Comment()
                                        {
                                            Id = 0,
                                            HomeWorkId = Second_Stu_HomeWork_Id,
                                            StuUid = Convert.ToInt32(sItem.student_uid),
                                            CourseId = cItem.course_id,
                                            Times = 2,
                                            Info = info,
                                            CreateType = 1,
                                            CreateByName = secondList.LastOrDefault().ThName,
                                            CreateTime = secondTime,
                                            ShowType = 3,
                                        });
                                    }
                                }
                            }
                            //第三次评价
                            if (homeWorkList.Count >= 13)
                            {
                                var thirdList = homeWorkList.Where(qitem => qitem.RowNum > 9 && qitem.RowNum <= 13).ToList();
                                var thirdSubmitCount = thirdList.Where(qitem => qitem.HomeWorkStatus == 0).Count();
                                //第三阶段有提交作业情况(至少一次)
                                if (thirdList.Count!= thirdSubmitCount)
                                {
                                    var thirdScore = thirdList.Average(qitem => qitem.Score_p) * 100;
                                    info = GetCommentInfo(courseCommentModel, thirdScore);
                                    var Third_Stu_HomeWork_Id = thirdList.LastOrDefault().Stu_HomeWork_Id;
                                    var thirdModel = GetSystemCreateComment(commentList, cItem.course_id, Third_Stu_HomeWork_Id);
                                    var thirdNum = CreateRandomNum();
                                    var thirdTime = thirdList.LastOrDefault().CreateTime;
                                    var fourthModel = homeWorkList.Where(qitem => qitem.RowNum == 14).FirstOrDefault();
                                    if (fourthModel != null)
                                    {
                                        double seconds = (fourthModel.CreateTime - thirdTime).TotalSeconds;
                                        Random rnd = new();
                                        var newSeconds = rnd.Next(0, Convert.ToInt32(seconds));
                                        thirdTime = thirdTime.AddSeconds(newSeconds);
                                    }
                                    else
                                    {
                                        thirdTime = thirdTime.AddMinutes(thirdNum);
                                    }
                                    if (thirdModel == null || (thirdModel != null && thirdModel.Id <= 0))
                                    {
                                        stuCommentRepository.SetStuCommentRepository(new RB_Stu_Comment()
                                        {
                                            Id = 0,
                                            HomeWorkId = Third_Stu_HomeWork_Id,
                                            StuUid = Convert.ToInt32(sItem.student_uid),
                                            CourseId = cItem.course_id,
                                            Times = 3,
                                            Info = info,
                                            CreateType = 1,
                                            CreateByName = thirdList.LastOrDefault().ThName,
                                            CreateTime = thirdList.LastOrDefault().CreateTime.AddMinutes(thirdNum),
                                            ShowType = 3,
                                        });
                                    }
                                }
                            }
                        }
                    }
                }
            }
           
            return list;
        }

        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        /// <returns></returns>
        public List<ExamWorkResult> GetStuHomeWorkListRepository(CourseQuery query)
        {
            List<ExamWorkResult> list = new();
            var dataList = GetStuHomeWorkDetailsListRepository(query);
            List<ExamWorkResult> homeWorkList = new();
            if (dataList != null && dataList.Count > 0)
            {
                int RowNum = 1;
                foreach (var item in dataList)
                {
                    homeWorkList.Add(new ExamWorkResult()
                    {
                        RowNum = RowNum,
                        CreateTime = item.add_time,
                        ResultType = 1,
                        Title = item.Homework_title,
                        Score = item.score,
                        Score_p = item.score_p,
                        ScoreType = item.score_type,
                        Score_Value = item.Score_value,
                        HomeWorkStatus = item.status,
                        ThName = item.th_name,
                        Stu_HomeWork_Id = item.stu_homework_id,
                    });
                    RowNum++;
                }
            }
 
            //学员评论列表
            var commentList = stuCommentRepository.GetStuCommentListRepository(new CourseQuery() { CourseId = query.CourseId, StuIds = query.StuIds });

            ExamWorkResult firstComment = null;
            ExamWorkResult secondComment = null;
            ExamWorkResult thirdComment = null;
            if (homeWorkList != null && homeWorkList.Count > 0)
            {
                //第一次评价
                if (homeWorkList.Count >= 5)
                {
                    var firstList = homeWorkList.Where(qitem => qitem.RowNum <= 5).ToList();
                    var First_Stu_HomeWork_Id = firstList.LastOrDefault().Stu_HomeWork_Id;
                    var tempModel = GetSystemCreateComment(commentList, query.CourseId, First_Stu_HomeWork_Id);
                    if (tempModel != null && tempModel.ShowType == 1)
                    {
                        firstComment = new ExamWorkResult()
                        {
                            ResultType = 3,
                            Title = firstList.LastOrDefault().ThName + "老师的评语",
                        };
                        firstComment.CreateTime = tempModel.CreateTime;
                        firstComment.Comment = tempModel.Info;
                    }
                }
                //第二次评价
                if (homeWorkList.Count >= 9)
                {
                    var secondList = homeWorkList.Where(qitem => qitem.RowNum > 5 && qitem.RowNum <= 9).ToList();
                    var Second_Stu_HomeWork_Id = secondList.LastOrDefault().Stu_HomeWork_Id;
                    var secondModel = GetSystemCreateComment(commentList, query.CourseId, Second_Stu_HomeWork_Id);
                    if (secondModel != null&&secondModel.ShowType==1)
                    {
                        secondComment = new ExamWorkResult()
                        {
                            ResultType = 3,
                            Title = secondList.LastOrDefault().ThName + "老师的评语",
                        };
                        secondComment.CreateTime = secondModel.CreateTime;
                        secondComment.Comment = secondModel.Info;
                    }
                }
                //第三次评价
                if (homeWorkList.Count >= 13)
                {
                    var thirdList = homeWorkList.Where(qitem => qitem.RowNum > 9 && qitem.RowNum <= 13).ToList();
                    var Third_Stu_HomeWork_Id = thirdList.LastOrDefault().Stu_HomeWork_Id;
                    var thirdModel = GetSystemCreateComment(commentList, query.CourseId, Third_Stu_HomeWork_Id);
                    if (thirdModel != null && thirdModel.ShowType == 1)
                    {
                        thirdComment = new ExamWorkResult()
                        {
                            ResultType = 3,
                            Title = thirdList.LastOrDefault().ThName + "老师的评语",
                        };
                        thirdComment.CreateTime = thirdModel.CreateTime;
                        thirdComment.Comment = thirdModel.Info;
                    }
                }
            }
            //添加系统自动生成评语
            for (var i = 0; i < homeWorkList.Count; i++)
            {
                var item = homeWorkList[i];

                list.Add(item);
                if (i == 4 && firstComment != null)
                {
                    list.Add(firstComment);
                }
                if (i == 8 && secondComment != null)
                {
                    list.Add(secondComment);
                }
                if (i == 12 && thirdComment != null)
                {
                    list.Add(thirdComment);
                }
            }
            //添加自定义评语
            if (commentList?.Where(qitem => qitem.CourseId == qitem.CourseId && qitem.CreateType == 2).Count() > 0)
            {
                foreach (var item in commentList?.Where(qitem => qitem.CourseId == qitem.CourseId && qitem.CreateType == 2))
                {
                    if (item.ShowType == 1)
                    {
                        list.Add(new ExamWorkResult()
                        {
                            CreateTime = item.CreateTime,
                            ResultType = 3,
                            Title = item.CreateByName + "老师的评语",
                            Comment = item?.Info
                        });

                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 生成随机数
        /// </summary>
        /// <returns></returns>
        private static int CreateRandomNum()
        {
            Random rnd = new();  
            return rnd.Next(5, 20);
        }

        /// <summary>
        /// 获取系统生成的评论
        /// </summary>
        /// <param name="commentList"></param>
        /// <param name="CourseId"></param>
        /// <param name="Stu_HomeWork_Id"></param>
        /// <returns></returns>
        private static RB_Stu_Comment GetSystemCreateComment(List<RB_Stu_Comment> commentList,int CourseId,int Stu_HomeWork_Id)
        {
            var tempModel = commentList.Where(qitem => qitem.CourseId == CourseId && qitem.HomeWorkId == Stu_HomeWork_Id && qitem.CreateType == 1).FirstOrDefault();
            return tempModel;
        }

        /// <summary>
        /// 获取课程评论或自定义评论
        /// </summary>
        /// <param name="courseCommentModel">课程评价配置</param>
        /// <param name="Score">平均分数</param>
        /// <returns></returns>
        private string GetCommentInfo(RB_Course_Comment_Extend courseCommentModel, decimal Score)
        {
            string info = "";
            var commentModel = commentRepository.GetComment(Score);
            if (courseCommentModel != null && courseCommentModel.CommentDetails != null && courseCommentModel.CommentDetails.Count() > 0)
            {
                var tempModel = courseCommentModel.CommentDetails.Where(qitem => qitem.StartNum <= Score && Score < qitem.EndNum)?.FirstOrDefault();
                if (tempModel != null)
                {
                    info = tempModel?.Info ?? "";
                }
                else
                {
                    info = commentModel?.Info ?? "";
                }
            }
            else
            {
                info = commentModel?.Info ?? "";
            }
            return info;
        }
    }
}
