// component/tarbar/tarbar.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    // 当前tartab值
    current: {
      type: String,
      value: "workbench"
    },
  },

  /**
   * 组件的初始数据
   */
  data: {
    currentList: {
      "workbench": 0,
      "product": 1,
      "news": 2,
      "mailList": 3,
      "mine": 4
    },
    tarbarList: [{
        "pagePath": "/pages/workbench/workbench",
        "iconPath": "/images/tarbar/ico_work_n.png",
        "selectedIconPath": "/images/tarbar/ico_work_h.png",
        "text": "工作台"
      },
      {
        "pagePath": "/pages/product/product",
        "iconPath": "/images/tarbar/ico_product_n.png",
        "selectedIconPath": "/images/tarbar/ico_product_h.png",
        "text": "产品"
      },
      {
        "pagePath": "/pages/news/news",
        "iconPath": "/images/tarbar/ico_talk_n.png",
        "selectedIconPath": "/images/tarbar/ico_talk_h.png",
        "text": "消息"
      },
      {
        "pagePath": "/pages/mailList/mailList",
        "iconPath": "/images/tarbar/ico_addres_list_n.png",
        "selectedIconPath": "/images/tarbar/ico_addres_list_h.png",
        "text": "通讯录"
      },
      {
        "pagePath": "/pages/mine/mine",
        "iconPath": "/images/tarbar/ico_me_n.png",
        "selectedIconPath": "/images/tarbar/ico_me_h.png",
        "text": "我的"
      }
    ]
  },

  /**
   * 组件的方法列表
   */
  methods: {},

  /**
   * 组件的进入节点前
   */
  created: function () {
    let nowNum = this.data.currentList[this.data.current];
    this.data.tarbarList[nowNum].current = 1;
  }
})