// pages/login/revisePwd/revisePwd.js

let app = getApp()

let codeClock = ''

Page({

  /**
   * 页面的初始数据
   */
  data: {
    account: '',
    code: '',
    password: '',
    repassword: '',
    codeTime: 60,
    reviseState: false
  },

  /**
   * 输入框输入
   */
  bindInput: function(e) {
    // 输入数据绑定
    let item = e.currentTarget.dataset.item
    this.setData({
      [item]: e.detail.value
    })
    // 判断提交状态
    let reviseState = false
    if (this.data.account !== '' && this.data.code !== '' && this.data.password !== '' && this.data.repassword !== '') {
      reviseState = true
    }
    this.setData({
      reviseState: reviseState
    })
  },

  /**
   * 获取验证码
   */
  getCode: function() {
    if (this.data.account === '') {
      wx.showToast({
        title: '请输入手机号',
        icon: 'none',
        duration: 1000
      })
    } else {
      if (this.data.codeTime === 60) {
        app.$api('miniProgram_customer_SendModifyPassowrdCodeByAccount', {
          account: this.data.account
        }).then(res => {
          codeClock = setInterval(() => {
            if (this.data.codeTime > 1) {
              this.setData({
                codeTime: this.data.codeTime - 1
              })
            } else {
              clearInterval(codeClock)
              this.setData({
                codeTime: 60
              })
            }
          }, 1000)
        }).catch(err => {})
      }
    }
  },

  /**
   * 确认修改
   */
  reviseOk: function() {
    if (this.data.reviseState === true) {
      if (this.data.password !== this.data.repassword) {
        wx.showToast({
          title: '两次密码不相同',
          icon: 'none',
          duration: 1000
        })
      } else {
        let data = {
          account: this.data.account,
          code: this.data.code,
          password: this.data.password
        }
        app.$api('miniProgram_customer_ModifyPasswordByAccountAndCode', data).then(res => {
          console.log('aaa')
          wx.showToast({
            title: '密码修改成功',
            icon: 'none',
            duration: 1000
          })
          setTimeout(() => {
            wx.navigateBack({
              delta: 1
            })
          }, 1000)
        }).catch(err => {})
      }
    }
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    wx.setNavigationBarColor({
      frontColor: '#000000',
      backgroundColor: '#ffffff',
      animation: {}
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  }
})