// pages/login/smsLogin/smsLogin.js

let app = getApp()

let codeClock = ''

Page({

  /**
   * 页面的初始数据
   */
  data: {
    account: '',
    code: '',
    codeTime: 60,
    smsState: false
  },

  /**
   * 输入框输入
   */
  bindInput: function (e) {
    // 输入数据绑定
    let item = e.currentTarget.dataset.item
    this.setData({
      [item]: e.detail.value
    })
    // 判断提交状态
    let smsState = false
    if (this.data.account !== '' && this.data.code !== '') {
      smsState = true
    }
    this.setData({
      smsState: smsState
    })
  },

  /**
   * 获取验证码
   */
  getCode: function () {
    if (this.data.account === '') {
      wx.showToast({
        title: '请输入手机号',
        icon: 'none',
        duration: 1000
      })
    } else {
      if (this.data.codeTime === 60) {
        app.$api('miniProgram_customer_SendCodeByAccount', {
          account: this.data.account
        }).then(res => {
          codeClock = setInterval(() => {
            if (this.data.codeTime > 1) {
              this.setData({
                codeTime: this.data.codeTime - 1
              })
            } else {
              clearInterval(codeClock)
              this.setData({
                codeTime: 60
              })
            }
          }, 1000)
        }).catch(err => {
          if (err.resultCode === 10007) {
            wx.navigateTo({
              url: '/pages/login/activate/activate'
            })
          }
        })
      }
    }
  },

  /**
   * 登录
   */
  signIn: function (e) {
    if (this.data.smsState === true) {
      wx.login({
        success: res => {
          if (res.code) {
            let data = {
              account: this.data.account,
              mobileNumber: this.data.account,
              sendcode: this.data.code,
              code: res.code
            }
            app.$api('miniProgram_customer_AccountLogin', data).then(res => {
              app.state.admin = res
              wx.setStorage({
                key: "admin",
                data: {
                  account: res.account,
                  address: res.address,
                  businessCardPhotos: res.businessCardPhotos,
                  contact: res.contact,
                  customerAccountId: res.customerAccountId,
                  housePhotos: res.housePhotos,
                  images: res.images,
                  isMember: res.isMember,
                  name: res.name,
                  photo: res.photo,
                  secretKey: res.secretKey,
                  token: res.token
                }
              })
              wx.reLaunch({
                url: '/pages/mine/mine'
              })
            }).catch(err => {
              if (err.resultCode === 10007) {
                wx.navigateTo({
                  url: '/pages/login/activate/activate'
                })
              }
            })
          } else {
            wx.showToast({
              title: '获取用户信息失败',
              icon: 'none',
              duration: 1000
            })
          }
        }
      })
    }
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    wx.setNavigationBarColor({
      frontColor: '#000000',
      backgroundColor: '#ffffff',
      animation: {}
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  }
})