// pages/product/product.js
let app = getApp();

Page({

  /**
   * 页面的初始数据
   */
  data: {
    isMember: 0,
    siteName: app.state.siteName,
    recommendList: [],
    line: [],
    lineList: [],
    headerList: [],
    todayHead: [],
    footerText: '',
    account:''
  },

  /**
   * 初始化函数
   */
  init: function() {
    // 获取列表数据
    app.$api('app_get_AppGetTrivelHomeSearchItem', {
      companyId: app.state.companyId
    }).then(res => {
      // 初始化筛选条件
      this.setData({
        headerList: res.destinationList,
        todayHead: res.todayHead
      })
      // 线路列表
      this.data.line = res.line
      let arr = []
      // 初始页面列表
      for (let i = 0; i < res.recommend.length; i++) {
        arr.push(res.recommend[i]);
        let msg = {
          pageIndex: '1',
          pageSize: '10',
          companyId: app.state.companyId,
          recommendType: res.recommend[i].id
        };
        if (res.recommend[i].id === 1) {
          arr[i]['subTitle'] = '走过路过，不要错过'
        } else if (res.recommend[i].id === 2) {
          arr[i]['subTitle'] = '尾单大甩卖，跳水特价每日更新'
        }
        app.$api('b2b_get_GetB2BHomeRecommendPageList', msg).then(res2 => {
          for (let j = 0; j < res2.pageData.length; j++) {
            if (res2.pageData[j].imgCover !== '' && res2.pageData[j].imgCover !== null) {
              res2.pageData[j].imgCover = (JSON.parse(res2.pageData[j].imgCover))[0].Url + '?x-oss-process=image/resize,m_fill,w_560,h_420'
            } else {
              res2.pageData[j].imgCover = ''
            }
          }
          arr[i]['list'] = res2.pageData
          let footerText = '没有更多了...'
          if (this.data.line.length > 0) {
            footerText = '上拉获取更多数据'
          }
          this.setData({
            recommendList: arr,
            lineList: [],
            footerText: footerText
          })
        }).catch(err => {})
      }
    }).catch(err => {})
  },

  /**
   * 获取更多数据
   */
  getMore: function() {
    if (this.data.line.length !== 0) {
      let arr = this.data.lineList;
      let item = this.data.line.shift();

      let msg = {
        pageIndex: '1',
        pageSize: '5',
        companyId: app.state.companyId,
        lineId: item.id,
        lineTeamId: 0,
        priceOrderByField: 0
      };

      app.$api('b2b_get_GetB2BHomeLineTravelPageList', msg).then(res => {
        for (let j = 0; j < res.pageData.length; j++) {
          if (res.pageData[j].imgCover !== '' && res.pageData[j].imgCover !== null) {
            res.pageData[j].imgCover = (JSON.parse(res.pageData[j].imgCover))[0].Url + '?x-oss-process=image/resize,m_fill,w_560,h_420'
          }
        }
        item['list'] = res.pageData
        if (res.pageData.length !== 0) {
          arr.push(item)
        }
        let footerText = '没有更多了...'
        if (this.data.line.length > 0) {
          footerText = '上拉获取更多数据'
        }
        this.setData({
          lineList: arr,
          footerText: footerText
        })
      }).catch(err => {})
    }
  },

  /**
   * 今日快讯禁止用户手动切换
   */
  stopTouchMove: function () {
    return false;
  },

  /**
   * 今日快讯更多
   */
  todayMove: function () {
    wx.navigateTo({
      url: 'productAll/productAll'
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.setData({
      isMember: app.state.admin.isMember,
      account: app.state.admin.account
    })
    // 页面路由跳转
    if (options.hasOwnProperty('jump')) {
      if (options.jump === '1' && options.hasOwnProperty('id')) {
        let tcid = options.hasOwnProperty('tcid') ? '&tcid=' + options.tcid : '';
        tcid += options.hasOwnProperty('ph') ? '&ph=' + options.ph : '';
        tcid += options.hasOwnProperty('pe') ? '&pe=' + options.pe : '';
        tcid += options.hasOwnProperty('c') ? '&c=' + options.c : '';
        wx.navigateTo({
          url: 'productDetail/productDetail?id=' + options.id + tcid
        })
      }
    }
    const scene = decodeURIComponent(options.scene)
    if (scene !== 'undefined') {
      let obj = scene.split('&&')
      let jump = obj[0].split('=')
      let id = obj[1].split('=')
      if (jump[1] == '1') {
        wx.navigateTo({
          url: 'productDetail/productDetail?id=' + id[1]
        })
      }
    }
    this.init()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    // 站点切换后重新获取数据
    if (this.data.siteName !== app.state.siteName) {
      this.setData({
        siteName: app.state.siteName
      })
      this.init();
    }
    // 登录变化后切换后重新获取数据
    if (this.data.isMember !== app.state.admin.isMember) {
      this.setData({
        isMember: app.state.admin.isMember
      })
      this.init();
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    this.init()
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {
    this.getMore()
  },
})