// pages/product/productAll/productAll.js

let app = getApp();

Page({

  /**
   * 页面的初始数据
   */
  data: {
    isMember: 0,
    dialogShow: true,
    typeList: [],
    typeNum: 0,
    siteName: app.state.siteName,
    line: [],
    lineNum: 0,
    lineView: 'line_0',
    orderByPrice: 0,
    orderByDate: 0,
    orderBySales: 0
  },

  /**
   * 跳转至站点选择
   */
  goToSite: function () {
    wx.navigateTo({
      url: '../productSite/productSite'
    })
  },

  /**
   * 初始化函数
   */
  init: function () {
    // 获取列表数据
    app.$api('app_get_AppGetProduceSearchItem', {
      companyId: app.state.companyId
    }).then(res => {
      let line = res[this.data.typeNum].searchItem.line
      for (let i = 0; i < line.length; i++) {
        line[i]['lineTeamNum'] = -1
        line[i]['seriesView'] = 'series_' +  i +'_left'
        line[i]['dataList'] = []
        line[i]['pageIndex'] = 0
        line[i]['moreState'] = true
      }
      this.setData({
        typeList: res,
        line: line
      })
      this.checkData(0)
    }).catch(err => {})
  },

  /**
   * 获取列表数据
   */
  checkData: function (num, isLine) {
    if (isLine === 'line' && this.data.line[num].pageIndex !== 0) {
      return
    }
    if (this.data.line[num].moreState === true) {
      let msg = {
        pageIndex: this.data.line[num].pageIndex + 1,
        pageSize: 10,
        searchKey: '',
        cityId: 0,
        lineId: this.data.line[num].id,
        lineTeamId: this.data.line[num].lineTeamNum,
        minTripDay: -1,
        startDate: '',
        endDate: '',
        minPrice: -1,
        maxPrice: -1,
        orderByPrice: this.data.orderByPrice,
        orderByDate: this.data.orderByDate,
        orderBySales: this.data.orderBySales,
        priceOrderByField: 0,
        companyId: app.state.companyId,
        maxTripDay: -1,
        startCityId: 0,
        dayNum: 0
      }
      app.$api('b2b_get_GetB2BTravelPageList', msg).then(res => {
        let arr = this.data.line[num].dataList;
        if (this.data.line[num].pageIndex === 0) {
          arr = []
        }
        for (let i = 0; i < res.pageData.length; i++) {
          if (res.pageData[i].imgCover !== '' && res.pageData[i].imgCover !== null) {
            res.pageData[i].imgCover = (JSON.parse(res.pageData[i].imgCover))[0].Url + '?x-oss-process=image/resize,m_fill,w_560,h_420'
          } else {
            res.pageData[i].imgCover = ''
          }
          arr.push(res.pageData[i])
        };
        
        let moreState = true

        if (res.pageIndex >= res.pageCount) {
          moreState = false
        }

        let pageIndex = res.pageIndex

        let text1 = 'line[' + num + '].pageIndex'
        let text2 = 'line[' + num + '].moreState'
        let text3 = 'line[' + num + '].dataList'
        this.setData({
          [text1]: pageIndex,
          [text2]: moreState,
          [text3]: arr
        })
      }).catch(err => {})
    }
  },

  /**
   * 滚动触底事件
   */
  scrollGetMore: function (e) {
    let index = e.currentTarget.dataset.index
    this.checkData(index)
  },

  /**
   * 类型切换，弹窗显示/隐藏
   */
  typeChange: function () {
    this.setData({
      dialogShow: !this.data.dialogShow
    })
  },
  dialog_box_click: function () {
    return false
  },

  /**
   * 线路点击事件
   */
  lineClick: function (e) {
    if (e.currentTarget.dataset.index !== this.data.lineNum) {
      let lineNum = e.currentTarget.dataset.index;
      this.setData({
        lineNum: lineNum,
        lineView: 'line_' + lineNum
      })
    }
  },

  /**
   * 滑动区域切换事件
   */
  swiperChange: function (e) {
    this.setData({
      lineNum: e.detail.current,
      lineView: 'line_' + e.detail.current
    })
    this.checkData(e.detail.current, 'line')
  },

  /**
   * 系列点击事件
   */
  seriesClick: function (e) {
    let index1 = e.currentTarget.dataset.index1
    let index2 = e.currentTarget.dataset.index2
    let text = 'line[' + index1 + '].lineTeamNum'
    if (this.data.line[index1].lineTeamNum !== index2) {
      this.setData({
        [text]: index2
      })
    } else {
      this.setData({
        [text]: -1
      })
    }

    this.data.line[index1].pageIndex = 0
    this.data.line[index1].moreState = true

    this.checkData(index1)
  },

  /**
   * 系列至左
   */
  seriesLeft: function (e) {
    let index = e.currentTarget.dataset.index
    let text = 'line[' + index + '].seriesView'
    this.setData({
      [text]: 'series_' + index + '_left'
    })
  },

  /**
   * 系列至右
   */
  seriesRight: function (e) {
    let index = e.currentTarget.dataset.index
    let text = 'line[' + index + '].seriesView'
    this.setData({
      [text]: 'series_' + index + '_right'
    })
  },

  /**
   * 价格切换
   */
  priceChange: function (e) {
    for (let i = 0; i < this.data.line.length; i++) {
      this.data.line[i].pageIndex = 0
      this.data.line[i].moreState = true
    }
    let index = e.currentTarget.dataset.index
    let num = 1
    if (this.data.orderByPrice === 1) {
      num = 2
    } else {
      num = 1
    }
    this.setData({
      orderByPrice: num,
      orderByDate: 0,
      orderBySales: 0
    })
    this.checkData(index)
  },

  /**
   * 团期切换
   */
  dateChange: function (e) {
    for (let i = 0; i < this.data.line.length; i++) {
      this.data.line[i].pageIndex = 0
      this.data.line[i].moreState = true
    }
    let index = e.currentTarget.dataset.index
    let num = 1
    if (this.data.orderByDate === 1) {
      num = 2
    } else {
      num = 1
    }
    this.setData({
      orderByPrice: 0,
      orderByDate: num,
      orderBySales: 0
    })
    this.checkData(index)
  },

  /**
   * 销量切换
   */
  salesChange: function (e) {
    for (let i = 0; i < this.data.line.length; i++) {
      this.data.line[i].pageIndex = 0
      this.data.line[i].moreState = true
    }
    let index = e.currentTarget.dataset.index
    let num = 1
    if (this.data.orderBySales === 1) {
      num = 2
    } else {
      num = 1
    }
    this.setData({
      orderByPrice: 0,
      orderByDate: 0,
      orderBySales: num
    })
    this.checkData(index)
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    this.setData({
      isMember: app.state.admin.isMember
    })
    this.init();
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {
    if (this.data.siteName !== app.state.siteName) {
      this.setData({
        siteName: app.state.siteName
      })
      this.init();
    }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {
    wx.stopPullDownRefresh();
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  }
})