const routes = [{
    path: '/',
    component: () =>
      import('layouts/HomeLayout.vue'),
    children: [{
        path: '',
        component: () =>
          import('pages/index.vue')
      },
      {
        path: '/index',
        component: () =>
          import('pages/index.vue')
      },
      {
        path: '/about', //关于我们
        component: () =>
          import('pages/about.vue')
      }, {
        path: '/contract', //契约管理
        component: () =>
          import('pages/contract.vue')
      }, {
        path: '/tour_visa', //签证护照管理
        component: () =>
          import('pages/tour_visa.vue')
      }, { //行程
        path: '/details/:id/:tcid',
        component: () =>
          import('pages/details.vue')
      }, {
        path: '/search', //签证护照管理
        component: () =>
          import('pages/search.vue')
      },
      {
        path: '/account', //用户信息
        component: () =>
          import('pages/usercenter/account.vue')
      },
      {
        path: '/demandlist', //需求单列表
        component: () =>
          import('pages/usercenter/demandlist.vue')
      },
      {
        path: '/demandinfo/:id', //需求单详情
        component: () =>
          import('pages/usercenter/demandinfo.vue')
      },
      {
        path: '/orderlist', //订单列表
        component: () =>
          import('pages/usercenter/orderlist.vue')
      },
      {
        path: '/orderinfo/:id', //订单详情
        component: () =>
          import('pages/usercenter/orderinfo.vue')
      },
      {
        path: '/passengerList/:id', //旅客名单
        component: () =>
          import('pages/usercenter/passengerList.vue')
      },
      {
        path: '/register', //用户注册
        component: () =>
          import('pages/usercenter/register.vue')
      },
      {
        path: '/customer/:id', //自定义页面
        component: () =>
          import('pages/customer.vue')
      },
    ]

  },
  {
    path: '/login',
    component: () =>
      import('pages/login.vue'),
    children: [{
      path: '/login',
      component: () =>
        import('pages/login.vue')
    }]
  }

]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
  routes.push({
    path: '*',
    component: () =>
      import('pages/Error404.vue')
  })
}

export default routes
