import Vue from 'vue'
import axios from 'axios'
import md5 from 'js-md5'

//域名管理对象
Vue.prototype.domainManager = function() {
    let domainUrl = '';
    domainUrl = "http://192.168.2.214:8082";
    //domainUrl="http://192.168.0.110";
    let locationName = window.location.hostname;
    if (locationName.indexOf('testerp.oytour') !== -1) {
        domainUrl = "http://testapi.oytour.com";
    } else if (locationName.indexOf('oytour') !== -1) {
        domainUrl = "http://reborn.oytour.com";
    }
    var obj = {
        //主地址
        DomainUrl: domainUrl,
        //常用提交数据URL
        PostUrl: domainUrl + "/api/common/post",
    };
    return obj;
}

//HTTP提交数据
Vue.prototype.apipost = function(cmd, msg, successCall, faildCall) {
    if (msg == null || msg == "") {
        msg = {}
    }
    var timestamp = (new Date()).valueOf();
    var apiurl = this.domainManager().PostUrl;
    var token = "";
    var key = "";
    var tempLanguage = 0;
    if (this.getLocalStorage() != null) {
        token = this.getLocalStorage().token;
        key = this.getLocalStorage().SecretKey;
    }
    var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
    var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);

    var postData = {
        msg: msg,
        cmd: cmd,
        timestamp: timestamp,
        token: token,
        sign: md5Str,
        languageId: tempLanguage
    }
    this.$axios.post(apiurl, postData, {
            headers: {
                'Content-Type': 'application/json',
                'Referer-Viitto': this.$route.path
            }
        })
        .then(res => {
            successCall(res);
        }, faildCall)
}

//获取缓存
Vue.prototype.getLocalStorage = function() {
    var localStorageData = window.localStorage["b2bUser"];
    if (localStorageData !== undefined && localStorageData != 'undefined') {
        return JSON.parse(localStorageData);
    } else {
        return null;
    }
}

//向外跳转
Vue.prototype.OpenNewUrl = function(URL) {
    if (URL && URL != '') {
        if (URL.indexOf("https") != -1) {
            var str = 'http://' + URL.substring(8);
            window.open(str, '_blank');
        } else if (URL.indexOf("http") != -1) {
            var str = 'http://' + URL.substring(7);
            window.open(str, '_blank');
        } else {
            window.open("http://" + URL, '_blank');
        }
    }
}

//公用跳转
Vue.prototype.CommonJump = function(path, obj) {
    this.$router.push({
        path: path,
        query: obj
    });
}