const routes = [{
    path: '/',
    component: () =>
      import('layouts/HomeLayout.vue'),
    children: [{
        path: '',
        component: () =>
          import('pages/Index.vue')
      },
      {
        path: '/Index',
        component: () =>
          import('pages/Index.vue')
      },
      {
        path: '/About', //关于我们
        component: () =>
          import('pages/About.vue')
      }, {
        path: '/contract', //契约管理
        component: () =>
          import('pages/contract.vue')
      }, {
        path: '/tour_visa', //签证护照管理
        component: () =>
          import('pages/tour_visa.vue')
      }, { //行程
        path: '/details/:id/:tcid',
        component: () =>
          import('pages/details.vue')
      }, {
        path: '/search', //签证护照管理
        component: () =>
          import('pages/search.vue')
      },
      {
        path: '/account', //用户信息
        component: () =>
          import('pages/usercenter/account.vue')
      },
      {
        path: '/demandlist', //需求单列表
        component: () =>
          import('pages/usercenter/demandlist.vue')
      },
      {
        path: '/orderlist', //订单列表
        component: () =>
          import('pages/usercenter/orderlist.vue')
      },
    ]

  },
  {
    path: '/login',
    component: () =>
      import('pages/login.vue'),
    children: [{
      path: '/login',
      component: () =>
        import('pages/login.vue')
    }]
  }

]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
  routes.push({
    path: '*',
    component: () =>
      import('pages/Error404.vue')
  })
}

export default routes
