const routes = [{
    path: '/',
    component: () =>
      import('layouts/HomeLayout.vue'),
    children: [{
        path: '/Index',
        component: () =>
          import('pages/Index.vue')
      },
      {
        path: '/About',
        component: () =>
          import('pages/About.vue')
      }
    ]
  },

]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
  routes.push({
    path: '*',
    component: () =>
      import('pages/Error404.vue')
  })
}

export default routes
