const routes = [{
        path: '/',
        component: () =>
            import ('layouts/HomeLayout.vue'),
        children: [{
                path: '',
                component: () =>
                    import ('pages/index.vue')
            },
            {
                path: '/index',
                component: () =>
                    import ('pages/index.vue')
            },
            {
                path: '/about', //关于我们
                component: () =>
                    import ('pages/about.vue')
            }, {
                path: '/contract', //契约管理
                component: () =>
                    import ('pages/contract.vue')
            }, {
                path: '/tour_visa', //签证护照管理
                component: () =>
                    import ('pages/tour_visa.vue')
            }, { //行程
                path: '/details/:id/:tcid',
                component: () =>
                    import ('pages/details.vue')
            }, { // 包车，接机
                path: '/detailCar/:id',
                component: () =>
                    import ('pages/detailsCar.vue')
            }, { // 包车，接机下单
                path: '/PickuporderForm/:id',
                component: () =>
                    import ('pages/Pickuporder/orderForm.vue')
            }, { // 景区门票详情
                path: '/detailsScenicSpotTicket/:id',
                component: () =>
                    import ('pages/ScenicSpotTicket/details.vue')
            }, { // 景区门票下单
                path: '/ScenicSpotTicketOrderForm/:id',
                component: () =>
                    import ('pages/ScenicSpotTicket/orderForm.vue')
            }, { // 酒店
                path: '/detailHotal/:id',
                component: () =>
                    import ('pages/detailsHotal.vue')
            }, { // 旅程
                path: '/detail/:id/:tcid/:newConfigId',
                component: () =>
                    import ('pages/detailsNew.vue')
            }, {
                path: '/search', //签证护照管理
                component: () =>
                    import ('pages/Search.vue')
            },
            {
                path: '/account', //用户信息
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/account.vue')
            },
            {
                path: '/demandlist', //需求单列表
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/demandlist.vue')
            },
            {
                path: '/demandinfo/:id', //需求单详情
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/demandinfo.vue')
            },
            {
                path: '/orderlist', //订单列表
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/orderlist.vue')
            },
            {
                path: '/orderinfo/:id', //订单详情
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/orderinfo.vue')
            },
            {
                path: '/passengerList/:id', //旅客名单
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/passengerList.vue')
            },
            {
                path: '/register', //用户注册
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/register.vue')
            },
            {
                path: '/loginInfo', //账户设置
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/loginInfo.vue')
            },
            {
                path: '/setAddress', //地址管理
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/setAddress.vue')
            },
            {
                path: '/setInfo', //账户设置
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/setInfo.vue')
            },
            {
                path: '/setUserInfo', //用户信息
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/setUserInfo.vue')
            },
            {
                path: '/coupon', //优惠券
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/coupon.vue')
            },
            {
                path: '/order', //用户订单
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/order.vue')
            },
            {
                path: '/setUsersList', //用户订单
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/setUsersList.vue')
            },
            {
                path: '/payInfo', //支付管理
                meta: { isUserCenter: true },
                component: () =>
                    import ('pages/usercenter/payInfo.vue')
            },
            {
                path: '/customer/:id', //自定义页面
                component: () =>
                    import ('pages/customer.vue')
            },
            {
                path: '/city/:id', //自定义页面
                component: () =>
                    import ('pages/city/cityDetail.vue')
            },
            {
                path: '/lineOrderPriview/:id?', //自定义页面
                component: () =>
                    import ('pages/line/orderPreview.vue')
            },
            {
                path: '/pay/:id?', //自定义页面
                component: () =>
                    import ('pages/pay.vue')
            },
        ]

    },
    {
        path: '/login',
        component: () =>
            import ('pages/login.vue'),
        children: [{
            path: '/login',
            component: () =>
                import ('pages/login.vue')
        }]
    },
    {
        path: '/resetPassword',
        component: () =>
            import ('pages/resetPassword.vue'),
        children: [{
            path: '/resetPassword',
            component: () =>
                import ('pages/resetPassword.vue')
        }]
    },
    {
        path: '/newTrip',
        component: () =>
            import ('pages/newTrip.vue')
    },
    {
        path: '/tripMobile',
        component: () =>
            import ('pages/tripMobile.vue')
    }
]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
    routes.push({
        path: '*',
        component: () =>
            import ('pages/Error404.vue')
    })
}

export default routes