import Vue from 'vue'
import axios from 'axios'
import md5 from 'js-md5'

Vue.prototype.$axios = axios

//域名管理对象
Vue.prototype.domainManager = function () {
  let domainUrl = '';
  domainUrl = "http://127.0.0.1";
  let locationName = window.location.hostname;
  if (locationName.indexOf('testerp.oytour') !== -1) {
    domainUrl = "http://testapi.oytour.com";
  } else if (locationName.indexOf('oytour') !== -1) {
    domainUrl = "http://reborn.oytour.com";
  }
  var obj = {
    //主地址
    DomainUrl: domainUrl,
    //常用提交数据URL
    PostUrl: domainUrl + "/api/common/post",
  };
  return obj;
}

//HTTP提交数据
Vue.prototype.apipost = function (cmd, msg, successCall, faildCall) {
  if (msg == null || msg == "") {
    msg = {}
  }
  var apiurl = this.domainManager().PostUrl;
  var timestamp = (new Date()).valueOf();
  this.apiurl = apiurl;
  var token = "";
  var key = "";
  var tempLanguage = 0;
  if (this.getLocalStorage() != null) {
    token = this.getLocalStorage().token;
    key = this.getLocalStorage().SecretKey;
  }
  var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
  var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);

  var postData = {
    "msg": msg,
    "cmd": cmd,
    "timestamp": timestamp,
    "token": token,
    "sign": md5Str,
    "languageId": tempLanguage
  }
  this.$axios.post(apiurl, postData, {
      headers: {
        'Content-Type': 'application/json',
        'Referer-Viitto': this.$route.path
      }
    })
    .then(res => {
      if (res.data.resultCode == 10000 || res.data.resultCode == 10001) {

      } else if (res.resultCode == 10005) {
        this.$router.go(-1);
      } else {
        successCall(res);
      }
    }, faildCall)
}

//ERP本地缓存
Vue.prototype.getLocalStorage = function () {
  var localStorageData = window.localStorage["b2bUser"];
  if (localStorageData !== undefined && localStorageData != 'undefined') {
    return JSON.parse(localStorageData);
  } else {
    return null;
  }
}

export default ({
  app
}) => {
  // Set i18n instance on app
  app.axios = axios
}

export {
  axios
}
