import EnumHelper from "./enumhelper"
import ListProductTypeEnum from "./listProductType"

const ProductTypeEnum = Object.freeze({
    /**
     * 一日游
     */
    ONE_DAY: {
        value: 1,
        desc: '當地遊产品'
    },
    /**
     * 多日游
     */
    TEAM_TRIP: {
        value: 2,
        desc: '出境遊产品'
    },
    /**
     * 小包团
     */
    UNIT_TRIP: {
        value: 3,
        desc: '小包团产品'
    },

    /**
     * 景点门票
     */
    SCENIC_SPOT: {
        value: 4,
        desc: '景点门票产品'
    },

    /**
     * 主题乐园
     */
    THEME_PART: {
        value: 5,
        desc: '主题乐园门票'
    },

    /**
     * 博物馆
     */
    MUSEUM: {
        value: 6,
        desc: '博物馆门票'
    },

    /**
     * 历史景点
     */
    HISTORY: {
        value: 7,
        desc: '历史景点门票'
    },

    /**
     * 温泉酒店
     */
    HOT_SPRING: {
        value: 8,
        desc: '温泉酒店产品'
    },

    /**
     * 星级酒店
     */
    STAR_HOTEL: {
        value: 9,
        desc: '星级酒店产品'
    },

    /**
     * 度假酒店
     */
    RESORT_HOTEL: {
        value: 10,
        desc: '度假酒店产品'
    },

    /**
     * 民宿
     */
    HOMESTAY: {
        value: 11,
        desc: '民宿产品'
    },

    /**
     * 包车
     */
    CHARTER: {
        value: 12,
        desc: '包车产品'
    },

    /**
     * 接机
     */
    PICK_UP: {
        value: 13,
        desc: '接机产品'
    },

    /**
     * 送机
     */
    DROP_OFF: {
        value: 14,
        desc: '送机产品'
    },
    VISARTER: {
        value: 15,
        desc: '签证产品'
    }


})

const mappingRules = [
    [-1],
    [1, 2, 3],
    [4, 5, 6, 7],
    [-1],
    [12, 13, 14],
    [8, 9, 10, 11],
    [15]
]

const mappingListType = (value) => {
    let val = mappingRules.findIndex(x => {
        return x.indexOf(value) != -1
    })

    console.log(val,value)
    if (val && val > 0) {
        return EnumHelper.ParseToEnum(ListProductTypeEnum, val, 'value')
    }
    return {}
}

const transProductEnum = (value) => {
    return mappingRules[value]
}

export default ProductTypeEnum

export { mappingListType, transProductEnum }