const routes = [{
        path: '/',
        component: () =>
            import ('layouts/HomeLayout.vue'),
        children: [{
                path: '',
                meta: { title: '首页' },
                component: () =>
                    import ('pages/home/index.vue')
            },
            {
                path: '/index',
                meta: { title: '首页' },
                component: () =>
                    import ('pages/home/index.vue')
            },
            {
                path: '/about', //关于我们
                meta: { title: '关于我们' },
                component: () =>
                    import ('pages/About.vue')
            }, {
                path: '/contract', //契约管理
                meta: { title: '契约管理' },
                component: () =>
                    import ('pages/contract.vue')
            }, {
                path: '/tour_visa', //签证护照管理
                meta: { title: '签证护照管理' },
                component: () =>
                    import ('pages/tour_visa.vue')
            }, { //行程
                path: '/details/:id/:tcid',
                meta: { title: '行程' },
                component: () =>
                    import ('pages/details.vue')
            }, { //行程2024
                path: '/detailsProduct/:id/:configId',
                meta: { title: '行程' },
                component: () =>
                    import ('pages/detailsProduct.vue')
            }, { // 包车，接机
                meta: { title: '包车，接机' },
                path: '/detailCar/:id',
                component: () =>
                    import ('pages/detailsCar.vue')
            }, { // 包车，接机下单
                path: '/PickuporderForm/:id',
                meta: { title: '包车，接机下单' },
                component: () =>
                    import ('pages/Pickuporder/orderForm.vue')
            }, { // 景区门票详情
                path: '/detailsScenicSpotTicket/:id',
                meta: { title: '景区门票详情' },
                component: () =>
                    import ('pages/ScenicSpotTicket/details.vue')
            }, { // 景区门票下单
                path: '/ScenicSpotTicketOrderForm/:id',
                meta: { title: '景区门票下单' },
                component: () =>
                    import ('pages/ScenicSpotTicket/orderForm.vue')
            }, { // 酒店
                path: '/detailHotal/:id/:b2CPrice',
                meta: { title: '酒店' },
                component: () =>
                    import ('pages/detailHotal.vue')
            }, { // 酒店下单
                path: '/HotalForm/:id',
                component: () =>
                    import ('pages/hotel/orderForm.vue')
            }, { // 旅程
                path: '/detail/:id/:tcid/:newConfigId',
                meta: { title: '旅程' },
                component: () =>
                    import ('pages/detailsNew.vue')
            }, {
                path: '/search', //出行检索
                meta: { title: '出行检索' },
                component: () =>
                    import ('pages/Search.vue')
            },{
                path: '/searchProduct', //出行产品（团）检索
                meta: { title: '出行检索' },
                component: () =>
                    import ('pages/SearchProduct.vue')
            },
            {
                path: '/account', //用户信息
                meta: { isUserCenter: true, needLogin: true, title: '用户信息' },
                component: () =>
                    import ('pages/usercenter/account.vue')
            },
            {
                path: '/demandlist', //需求单列表
                meta: { isUserCenter: true, needLogin: true, title: '需求单列表' },
                component: () =>
                    import ('pages/usercenter/demandlist.vue')
            },
            {
                path: '/demandinfo/:id', //需求单详情
                meta: { isUserCenter: true, needLogin: true, title: '需求单详情' },
                component: () =>
                    import ('pages/usercenter/demandinfo.vue')
            },
            {
                path: '/orderlist', //订单列表
                meta: { isUserCenter: true, needLogin: true, title: '订单列表' },
                component: () =>
                    import ('pages/usercenter/orderlist.vue')
            },
            // {
            //     path: '/orderinfo/:id', //订单详情
            //     meta: { isUserCenter: true, needLogin: true, title: '订单详情' },
            //     component: () =>
            //         import ('pages/usercenter/orderinfo.vue')
            // },
            {
                path: '/passengerList/:id', //旅客名单
                meta: { isUserCenter: true, needLogin: true, title: '旅客名单' },
                component: () =>
                    import ('pages/usercenter/passengerList.vue')
            },
            {
                path: '/register', //用户注册
                meta: { isUserCenter: true, needLogin: true, title: '用户注册' },
                component: () =>
                    import ('pages/usercenter/register.vue')
            },
            {
                path: '/loginInfo', //账户设置
                meta: { isUserCenter: true, needLogin: true, title: '账户设置' },
                component: () =>
                    import ('pages/usercenter/loginInfo.vue')
            },
            {
                path: '/setAddress', //地址管理
                meta: { isUserCenter: true, needLogin: true, title: '地址管理' },
                component: () =>
                    import ('pages/usercenter/setAddress.vue')
            },
            {
                path: '/setInfo', //账户设置
                meta: { isUserCenter: true, needLogin: true, title: '账户设置' },
                component: () =>
                    import ('pages/usercenter/setInfo.vue')
            },
            {
                path: '/setUserInfo', //用户信息
                meta: { isUserCenter: true, needLogin: true, title: '用户信息' },
                component: () =>
                    import ('pages/usercenter/setUserInfo.vue')
            },
            {
                path: '/coupon', //优惠券
                meta: { isUserCenter: true, needLogin: true, title: '优惠券' },
                component: () =>
                    import ('pages/usercenter/coupon.vue')
            },
            {
                path: '/order', //用户订单
                meta: { isUserCenter: true, needLogin: true, title: '用户订单' },
                component: () =>
                    import ('pages/usercenter/order.vue')
            },
            {
                path: '/setUsersList', //出行人管理
                meta: { isUserCenter: true, needLogin: true, title: '出行人管理' },
                component: () =>
                    import ('pages/usercenter/setUsersList.vue')
            },
            {
                path: '/payInfo', //支付管理
                meta: { isUserCenter: true, needLogin: true, title: '支付管理' },
                component: () =>
                    import ('pages/usercenter/payInfo.vue')
            },
            {
                path: '/customer/:id', //顾客管理
                meta: { title: '顾客管理' },
                component: () =>
                    import ('pages/customer.vue')
            },
            {
                path: '/city/:id', //城市详情
                meta: { title: '城市详情' },
                component: () =>
                    import ('pages/city/cityDetail.vue')
            },
            {
                path: '/lineOrderPriview/:id?', //订单确认
                meta: { title: '订单确认' },
                component: () =>
                    import ('pages/line/orderPreview.vue')
            },
            {
                path: '/pay/:id?', //自定义页面
                meta: { title: '订单支付' },
                component: () =>
                    import ('pages/pay/pay.vue')
            },
            {
                path: '/paysuccess/:id?', //支付结果
                meta: { title: '支付结果' },
                component: () =>
                    import ('pages/pay/paysuccess.vue')
            },
            {
                path: '/orderinfo/:orderNo', //訂單詳情
                meta: { title: '訂單詳情', isUserCenter: false, needLogin: true, },
                component: () =>
                    import ('pages/usercenter/order/orderDetail.vue')
            },
        ]

    },
    {
        path: '/userCenter', //移动端个人中心
        meta: { isUserCenter: true, needLogin: true, title: '个人中心' },
        component: () =>
            import ('pages/usercenter/mobileUserCenter.vue')
    },
    {
        path: '/login',
        meta: { title: '登录' },
        component: () =>
            import ('pages/login.vue'),
        children: [{
            path: '/login',
            meta: { title: '登录' },
            component: () =>
                import ('pages/login.vue')
        }]
    },
    {
        path: '/resetPassword',
        meta: { title: '重置密码' },
        component: () =>
            import ('pages/resetPassword.vue'),
        children: [{
            path: '/resetPassword',
            meta: { title: '重置密码' },
            component: () =>
                import ('pages/resetPassword.vue')
        }]
    },
    {
        path: '/newTrip',
        meta: { title: '旅程' },
        component: () =>
            import ('pages/newTrip.vue')
    },
    {
        path: '/tripMobile',
        meta: { title: '旅程' },
        component: () =>
            import ('pages/tripMobile.vue')
    }
]

// Always leave this as last one
if (process.env.MODE !== 'ssr') {
    routes.push({
        path: '*',
        component: () =>
            import ('pages/Error404.vue')
    })
}

export default routes
