import { RouteRecordRaw } from 'vue-router'


const routes: RouteRecordRaw[] = [
  {
    path: '/',
    component: () => import('@/views/Website/index.vue'),
    meta:{
      title:'Travel Design 一个面向旅游行程设计的创作平台'
    }
  },
  {
    path: '/space',
    component: () => import('@/views/Index.vue'),
    meta:{
      title:'个人空间'
    },
    children:[
      {
        path: '/space',
        component: () => import('@/views/SellTemplate/Workspace.vue'),
        meta:{
          title:'个人空间'
        }
      },
      {
        path: '/space/:current(\\d+)?/:firm(\\d+)?',
        component: () => import('@/views/SellTemplate/Workspace.vue'),
        meta:{
          title:'个人空间'
        }
      },
      {
        path: '/space/cp',
        component: () => import('@/views/Company/Product.vue'),
        meta:{
          title:'升级到企业版本'
        }
      }
    ]
  },
  {
    path: '/login/:Current?',
    component: () => import('@/views/Auth/Login.vue'),
    meta:{
      title:'登录 Travel Design'
    }
  },
  {
    path: '/regist',
    component: () => import('@/views/Auth/Regist.vue'),
    meta:{
      title:'注册 Travel Design'
    }
  },
  {
    path: '/BindToWechat',
    component: () => import('@/views/Auth/BindToWechat.vue'),
    meta:{
      title:'绑定微信'
    }
  },
  {
    path: '/forgot',
    component: () => import('@/views/Auth/Forgot.vue'),
    meta:{
      title:'忘记密码 Travel Design'
    }
  },
  {
    path: '/newpass/:code(\\d+)/:token',
    component: () => import('@/views/Auth/Forgot.vue'),
    meta:{
      title:'忘记密码 Travel Design'
    }
  },
  {
    path: '/notfound',
    component: () => import('@/views/ErrorNotFound.vue'),
    meta:{
      title:'Oops! 出错了'
    }
  },
  {
    path: '/download/:token',
    component: () => import('@/views/SellTemplate/Download.vue'),
    meta:{
      title:'下载行程设计'
    }
  },
  {
    path: '/denyAccess',
    component: () => import('@/views/Auth/DenyAccess.vue'),
    meta:{
      title:'禁止访问'
    }
  },
  {
    path: '/notsupported',
    component: () => import('@/views/Mobile/NotSupported.vue'),
    meta:{
      title:'Oops! 我们不支持这样做'
    }
  },
  {
    path: '/autoLogin',
    component: () => import('@/views/Auth/AutoLogin.vue'),
    meta:{
      title:'自动登录中...'
    }
  },
  {
    path: '/market',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'模板管理'
    }
  },
  {
    path: '/market/create',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择模板进行创作'
    }
  },
  {
    path: '/market/create/ad/:current?',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择广告模板'
    }
  },
  {
    path: '/market/create/trip/:current?',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择行程模板'
    }
  },
  {
    path: '/market/op/:configId(\\d+)/:temptype(\\d+)?',
    component: () => import('@/views/Market/Index.vue'),
    meta:{
      title:'选择模板进行创作'
    }
  },
  {
    path: '/editor/:id(\\d+)/:tid(\\d+)/:type(\\d+)/:pid(\\d+)/e/:e(\\d+)/c/:c(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'编辑'
    }
  },
  {
    path: '/editor/:tid(\\d+)/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/team_editor/:configId(\\d+)/:tempType(\\d+)/:tid(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'设计团队行程'
    }
  },
  {
    path: '/team_editor/:configId(\\d+)/:tempType(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'修改团队行程'
    }
  },
  {
    path: '/manager_template/:tid(\\d+)/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/create_template/:type(\\d+)',
    component: () => import('@/views/Editor/Editor.vue'),
    meta:{
      title:'新建'
    }
  },
  {
    path: '/team_preview/:configId(\\d+)/:w(\\d+)?',
    component: () => import('@/views/Editor/Preview.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/preview/:tid(\\d+)',
    component: () => import('@/views/Preview/PreviewCustomSlider.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/PreviewCover/:tempId(\\d+)',
    component: () => import('@/views/Preview/PreviewCover.vue'),
    meta:{
      title:'预览封面'
    }
  },
  {
    path: '/play/:id(\\d+)/:logId(\\d+)/:status(\\d+)',
    component: () => import('@/views/Editor/PlayView.vue'),
    meta:{
      title:'行程生成预览'
    }
  },
  {
    path: '/a',
    component: () => import('@/views/TeamCenter/Layout.vue'),
    meta:{
      title:'团队/企业管理与设置中心'
    },
    children:[
      {
        path: '/a',
        component: () => import('@/views/TeamCenter/Index.vue'),
        meta:{
          title:'团队/企业管理与设置中心'
        }
      },
      {
        path: '/a/u',
        component: () => import('@/views/TeamCenter/Member.vue'),
        meta:{
          title:'成员管理'
        }
      },
      {
        path: '/a/w',
        component: () => import('@/views/TeamCenter/WaterMaker.vue'),
        meta:{
          title:'水印设置'
        }
      },
      {
        path: '/a/c',
        component: () => import('@/views/TeamCenter/CloudDiskSpace.vue'),
        meta:{
          title:'云盘空间'
        }
      },
      {
        path: '/a/l',
        component: () => import('@/views/TeamCenter/LogoDisposition.vue'),
        meta:{
          title:'LOGO设置'
        }
      },
      {
        path: '/a/order/:activeName?',
        component: () => import('@/views/TeamCenter/Order.vue'),
        meta:{
          title:'我的订单/发票'
        }
      },
      {
        path: '/a/info',
        component: () => import('@/views/TeamCenter/OrgInfo.vue'),
        meta:{
          title:'基本信息'
        }
      },
      {
        path: '/a/diss',
        component: () => import('@/views/TeamCenter/Dissolution.vue'),
        meta:{
          title:'解散团队/组织'
        }
      },
      {
        path: '/a/orderDetail/:id/:isFirm/:activeName',
        component: () => import('@/views/TeamCenter/OrderDetail.vue'),
        meta:{
          title:'订单详情'
        }
      },
    ]
  },
  {
    path: '/u',
    component: () => import('@/views/UserCenter/Layout.vue'),
    meta:{
      title:'管理与设置中心'
    },
    children:[
      {
        path: '/u',
        component: () => import('@/views/UserCenter/Index.vue'),
        meta:{
          title:'账号一览'
        }
      },
      {
        path: '/u/w',
        component: () => import('@/views/TeamCenter/WaterMaker.vue'),
        meta:{
          title:'水印设置'
        }
      },
      {
        path: '/u/order/:activeName?',
        component: () => import('@/views/UserCenter/Order.vue'),
        meta:{
          title:'我的订单/发票'
        }
      },
      {
        path: '/u/orderDetail/:id/:activeName',
        component: () => import('@/views/UserCenter/OrderDetail.vue'),
        meta:{
          title:'订单详情'
        }
      },
      {
        path: '/u/setting',
        component: () => import('@/views/UserCenter/Setting.vue'),
        meta:{
          title:'账户设置'
        }
      },
      {
        path: '/u/cloudDiskSpace',
        component: () => import('@/views/UserCenter/CloudDiskSpace.vue'),
        meta:{
          title:'云盘空间'
        }
      },
    ]
  },
  {
    path: '/m',
    component: () => import('@/views/TemplateCenter/Layout.vue'),
    meta:{
      title:'模版管理与设置中心'
    },
    children:[
      {
        path: '/m',
        component: () => import('@/views/TemplateCenter/Index.vue'),
        meta:{
          title:'模版管理'
        }
      },
      {
        path: '/m/nation',
        component: () => import('@/views/TemplateCenter/nation.vue'),
        meta:{
          title:'国家'
        }
      },
      {
        path: '/m/colour',
        component: () => import('@/views/TemplateCenter/colour.vue'),
        meta:{
          title:'颜色'
        }
      },
      {
        path: '/m/font',
        component: () => import('@/views/TemplateCenter/font.vue'),
        meta:{
          title:'字体'
        }
      },
    ]
  },
  {
    path: '/d',
    component: () => import('@/views/DesignSpecification/Layout.vue'),
    meta:{
      title:'模版设计规范'
    },
    children:[
      {
        path: '/d',
        component: () => import('@/views/DesignSpecification/Index.vue'),
        meta:{
          title:'设计规范'
        }
      },
    ]
  },
  {
    path: '/p/show',
    component: () => import('@/views/Product/Show.vue'),
    meta:{
      title:'产品介绍'
    }
  },
  {
    path: '/j/:code',
    component: () => import('@/views/TeamCenter/Join.vue'),
    meta:{
      title:'产品介绍'
    }
  },
  {
    path: '/:catchAll(.*)*',
    component: () => import('@/views/ErrorNotFound.vue'),
    meta:{
      title:'Oops! 出错了'
    }
  }
];

export default routes;