import UserService from '@/services/UserService';
import { defineStore } from 'pinia';

export const userStore = defineStore('user', {
    state:()=>({
        token:'' as string,
        userInfo:{} as any
    }),
    getters: {
        getUserToken: (state) => {
          return state.token;
        },
        getUser: (state) => {
          return state.userInfo;
        },
    },
    actions:{
        async setUserLoginAsync(userId:number){
            try {
                let response = await UserService.LoginAsync(userId)
                if (response.data.resultCode == 1) {
                    this.token = response.data.data.token
                    this.userInfo = response.data.data
                }
            } catch (error) {}
        }
    }
});